"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CalendarsSelection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _dst_utils = require("../../../../../../../../../settings/calendars/dst_utils");
var _job_creator_context = require("../../../../../job_creator_context");
var _description = require("./description");
var _kibana = require("../../../../../../../../../contexts/kibana");
var _calendars = require("../../../../../../../../../../../common/constants/calendars");
var _locator = require("../../../../../../../../../../../common/constants/locator");
var _description_dst = require("./description_dst");
var _use_create_url = require("../../../../../../../../../contexts/kibana/use_create_url");
var _management = require("../../../../../../../../../management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/job_details_step/components/additional_section/components/calendars/calendars_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CalendarsSelection = ({
  isDst = false
}) => {
  const mlApi = (0, _kibana.useMlApi)();
  const {
    jobCreator,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [selectedCalendars, setSelectedCalendars] = (0, _react.useState)((0, _dst_utils.filterCalendarsForDst)(jobCreator.calendars, isDst));
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const [options, setOptions] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'calendarsSelection'
  });
  async function loadCalendars() {
    setIsLoading(true);
    const {
      calendars,
      calendarsDst
    } = (0, _dst_utils.separateCalendarsByType)(await mlApi.calendars());
    const filteredCalendars = (isDst ? calendarsDst : calendars).filter(c => c.job_ids.includes(_calendars.GLOBAL_CALENDAR) === false);
    setOptions(filteredCalendars.map(c => ({
      label: c.calendar_id,
      value: c
    })));
    setSelectedOptions(selectedCalendars.map(c => ({
      label: c.calendar_id,
      value: c
    })));
    setIsLoading(false);
  }
  (0, _react.useEffect)(() => {
    loadCalendars();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    const {
      calendars,
      calendarsDst
    } = (0, _dst_utils.separateCalendarsByType)(jobCreator.calendars);
    const otherCalendars = isDst ? calendars : calendarsDst;
    jobCreator.calendars = [...selectedCalendars, ...otherCalendars];
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedCalendars.join()]);
  const comboBoxProps = {
    async: true,
    options,
    selectedOptions,
    isLoading,
    onChange: optionsIn => {
      setSelectedOptions(optionsIn);
      setSelectedCalendars(optionsIn.map(o => o.value));
    }
  };
  const manageCalendarsHref = (0, _use_create_url.useMlManagementLink)(isDst ? _locator.ML_PAGES.CALENDARS_DST_MANAGE : _locator.ML_PAGES.CALENDARS_MANAGE, _management.MANAGEMENT_SECTION_IDS.AD_SETTINGS);
  const Desc = isDst ? _description_dst.DescriptionDst : _description.Description;
  return /*#__PURE__*/_react.default.createElement(Desc, {
    titleId: isDst ? `Dst${titleId}` : titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, comboBoxProps, {
    "data-test-subj": "mlJobWizardComboBoxCalendars",
    "aria-labelledby": isDst ? `Dst${titleId}` : titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.jobDetailsStep.additionalSection.calendarsSelection.refreshCalendarsButtonLabel",
      defaultMessage: "Refresh calendars",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "refresh",
    color: "primary",
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.wizard.jobDetailsStep.additionalSection.calendarsSelection.refreshCalendarsButtonLabel', {
      defaultMessage: 'Refresh calendars'
    }),
    onClick: loadCalendars,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: manageCalendarsHref,
    target: "_blank",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobDetailsStep.additionalSection.calendarsSelection.manageCalendarsButtonLabel",
    defaultMessage: "Manage calendars",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }))));
};
exports.CalendarsSelection = CalendarsSelection;