"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStringifiedValue = useStringifiedValue;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useStringifiedValue(initialValue) {
  const [value, setValueInner] = (0, _react.useState)(stringify(initialValue));
  function stringify(f) {
    return f === null ? '' : f;
  }
  function setValue(f) {
    setValueInner(stringify(f));
  }
  return {
    value,
    setValue
  };
}