"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobGroupsInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _group_color_utils = require("../../../../../../common/util/group_color_utils");
var _description = require("../../pages/components/job_details_step/components/groups/description");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/common/components/job_groups_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JobGroupsInput = exports.JobGroupsInput = /*#__PURE__*/(0, _react.memo)(({
  existingGroups,
  selectedGroups,
  onChange,
  validation
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'jobGroupsInput'
  });
  const options = existingGroups.map(g => ({
    label: g,
    color: (0, _group_color_utils.tabColor)(g, euiTheme)
  }));
  const selectedOptions = selectedGroups.map(g => ({
    label: g,
    color: (0, _group_color_utils.tabColor)(g, euiTheme)
  }));
  function onChangeCallback(optionsIn) {
    onChange(optionsIn.map(g => g.label));
  }
  function onCreateGroup(input, flattenedOptions) {
    const normalizedSearchValue = input.trim().toLowerCase();
    if (!normalizedSearchValue) {
      return;
    }
    const newGroup = {
      label: input,
      color: (0, _group_color_utils.tabColor)(input, euiTheme)
    };
    if (flattenedOptions.findIndex(option => option.label.trim().toLowerCase() === normalizedSearchValue) === -1) {
      options.push(newGroup);
    }
    onChangeCallback([...selectedOptions, newGroup]);
  }
  const jobGroupSelectLabel = _i18n.i18n.translate('xpack.ml.newJob.wizard.jobDetailsStep.jobGroupSelect.placeholder', {
    defaultMessage: 'Select or create groups'
  });
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation,
    titleId: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: jobGroupSelectLabel,
    "aria-label": jobGroupSelectLabel,
    options: options,
    selectedOptions: selectedOptions,
    onChange: onChangeCallback,
    onCreateOption: onCreateGroup,
    isClearable: true,
    isInvalid: !validation.valid,
    "data-test-subj": "mlJobWizardComboBoxJobGroups",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }));
});