"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCategoryFields = getCategoryFields;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getCategoryFields(mlApi, indexPatternName, fieldName, size, query, runtimeMappings, indicesOptions) {
  return new Promise((resolve, reject) => {
    mlApi.esSearch({
      index: indexPatternName,
      size: 0,
      body: {
        query,
        aggs: {
          catFields: {
            terms: {
              field: fieldName,
              size
            }
          }
        },
        ...(runtimeMappings !== undefined ? {
          runtime_mappings: runtimeMappings
        } : {})
      },
      ...(indicesOptions !== null && indicesOptions !== void 0 ? indicesOptions : {})
    }).then(resp => {
      const catFields = (0, _lodash.get)(resp, ['aggregations', 'catFields', 'buckets'], []);
      resolve({
        success: true,
        results: catFields.map(f => f.key)
      });
    }).catch(resp => {
      reject(resp);
    });
  });
}