"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartDatafeedModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _jobs_utils = require("../../../jobs_utils");
var _utils = require("../utils");
var _time_range_selector = require("./time_range_selector");
var _i18n = require("@kbn/i18n");
var _create_focus_restoration = require("../../../../util/create_focus_restoration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/start_datafeed_modal/start_datafeed_modal.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class StartDatafeedModal extends _react.Component {
  constructor(props, constructorContext) {
    super(props, constructorContext);
    (0, _defineProperty2.default)(this, "setStartTime", time => {
      this.setState({
        startTime: time
      });
    });
    (0, _defineProperty2.default)(this, "setEndTime", time => {
      this.setState({
        endTime: time
      });
    });
    (0, _defineProperty2.default)(this, "setCreateAlert", e => {
      this.setState({
        createAlert: e.target.checked
      });
    });
    (0, _defineProperty2.default)(this, "closeModal", () => {
      this.setState({
        isModalVisible: false
      });

      // Manually return focus to the start datafeed action button
      // This is a workaround to fix the issue where the focus is not returned to the action button when the modal is closed
      if (this.state.jobs.length === 1) {
        (0, _create_focus_restoration.createJobActionFocusRestoration)(this.state.jobs[0].id)();
      }
    });
    (0, _defineProperty2.default)(this, "setTimeRangeValid", timeRangeValid => {
      this.setState({
        timeRangeValid
      });
    });
    (0, _defineProperty2.default)(this, "showModal", (jobs, showCreateAlertFlyout) => {
      const startTime = undefined;
      const now = (0, _moment.default)();
      const endTime = now;
      const initialSpecifiedStartTime = getLowestLatestTime(jobs);
      const allowCreateAlert = jobs.length > 0;
      this.setState({
        jobs,
        isModalVisible: true,
        startTime,
        endTime,
        initialSpecifiedStartTime,
        showCreateAlertFlyout,
        allowCreateAlert,
        createAlert: false,
        now,
        hasManagedJob: jobs.some(j => (0, _jobs_utils.isManagedJob)(j))
      });
    });
    (0, _defineProperty2.default)(this, "save", () => {
      const {
        jobs
      } = this.state;
      const start = _moment.default.isMoment(this.state.startTime) ? this.state.startTime.valueOf() : this.state.startTime;
      const end = _moment.default.isMoment(this.state.endTime) ? this.state.endTime.valueOf() : this.state.endTime;
      (0, _utils.forceStartDatafeeds)(this.toastNotifications, this.mlApi, jobs, start, end, () => {
        if (this.state.createAlert && jobs.length > 0) {
          this.getShowCreateAlertFlyoutFunction()(jobs.map(job => job.id));
        }
        this.refreshJobs();
      });
      this.closeModal();
    });
    const _now = (0, _moment.default)();
    this.state = {
      jobs: this.props.jobs,
      isModalVisible: false,
      startTime: _now,
      endTime: _now,
      createAlert: false,
      allowCreateAlert: false,
      initialSpecifiedStartTime: _now,
      now: _now,
      timeRangeValid: true,
      hasManagedJob: false
    };
    this.initialSpecifiedStartTime = _now;
    this.refreshJobs = this.props.refreshJobs;
    this.getShowCreateAlertFlyoutFunction = this.props.getShowCreateAlertFlyoutFunction;
    this.toastNotifications = constructorContext.services.notifications.toasts;
    this.mlApi = constructorContext.services.mlServices.mlApi;
  }
  componentDidMount() {
    if (typeof this.props.setShowFunction === 'function') {
      this.props.setShowFunction(this.showModal);
    }
  }
  componentWillUnmount() {
    if (typeof this.props.unsetShowFunction === 'function') {
      this.props.unsetShowFunction();
    }
  }
  render() {
    const {
      jobs,
      initialSpecifiedStartTime,
      startTime,
      endTime,
      createAlert,
      now,
      timeRangeValid
    } = this.state;
    const startableJobs = jobs !== undefined ? jobs.filter(j => j.hasDatafeed) : [];
    // disable start button if the start and end times are the same
    const startDisabled = timeRangeValid === false || startTime !== undefined && startTime === endTime;
    let modal;
    if (this.state.isModalVisible) {
      modal = /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
        onClose: this.closeModal,
        style: {
          minWidth: '850px'
        },
        maxWidth: false,
        "data-test-subj": "mlStartDatafeedModal",
        "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.startDatafeedModal.ariaLabel', {
          defaultMessage: 'Start datafeed modal'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.startDatafeedModal.startJobsTitle",
        defaultMessage: "Start {jobsCount, plural, one {{jobId}} other {# jobs}}",
        values: {
          jobsCount: startableJobs.length,
          jobId: startableJobs[0].id
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 15
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_time_range_selector.TimeRangeSelector, {
        startTime: startTime === undefined ? initialSpecifiedStartTime : startTime,
        endTime: endTime,
        setStartTime: this.setStartTime,
        setEndTime: this.setEndTime,
        now: now,
        setTimeRangeValid: this.setTimeRangeValid,
        hasManagedJob: this.state.hasManagedJob,
        jobsCount: startableJobs.length,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 13
        }
      }), this.state.endTime === undefined && /*#__PURE__*/_react.default.createElement("div", {
        className: "create-watch",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        id: "createAlert",
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.jobsList.startDatafeedModal.createAlertDescription",
          defaultMessage: "Create alert rule after datafeed has started",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 196,
            columnNumber: 21
          }
        }),
        checked: createAlert,
        onChange: this.setCreateAlert,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: this.closeModal,
        "data-test-subj": "mlStartDatafeedModalCancelButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 209,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.startDatafeedModal.cancelButtonLabel",
        defaultMessage: "Cancel",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.save,
        isDisabled: startDisabled,
        fill: true,
        "data-test-subj": "mlStartDatafeedModalStartButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.startDatafeedModal.startButtonLabel",
        defaultMessage: "Start",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 225,
          columnNumber: 15
        }
      }))));
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 12
      }
    }, modal);
  }
}
exports.StartDatafeedModal = StartDatafeedModal;
(0, _defineProperty2.default)(StartDatafeedModal, "contextType", _public.context);
StartDatafeedModal.propTypes = {
  setShowFunction: _propTypes.default.func.isRequired,
  unsetShowFunction: _propTypes.default.func.isRequired,
  refreshJobs: _propTypes.default.func.isRequired
};
function getLowestLatestTime(jobs) {
  const times = jobs.map(j => j.earliestStartTimestampMs || 0);
  return (0, _moment.default)(Math.min(...times));
}