"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionAlertsOverviewChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _anomaly_explorer_context = require("../anomaly_explorer_context");
var _kibana = require("../../contexts/kibana");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/alerts/chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnomalyDetectionAlertsOverviewChart = ({
  seriesType = 'line'
}) => {
  const {
    services: {
      lens: {
        EmbeddableComponent
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    anomalyTimelineStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const timeRange = (0, _mlDatePicker.useTimeRangeUpdates)();
  const interval = (0, _useObservable.default)(anomalyTimelineStateService.getSwimLaneBucketInterval$(), anomalyTimelineStateService.getSwimLaneBucketInterval());
  const attributes = (0, _react.useMemo)(() => {
    return {
      title: '',
      visualizationType: 'lnsXY',
      references: [],
      type: 'lens',
      state: {
        internalReferences: [{
          type: 'index-pattern',
          id: 'ml-alerts-data-view',
          name: 'indexpattern-datasource-layer-layer1'
        }],
        adHocDataViews: {
          'ml-alerts-data-view': {
            id: 'ml-alerts-data-view',
            title: '.alerts-ml.anomaly-detection.alerts-default',
            timeFieldName: '@timestamp'
          }
        },
        visualization: {
          hideEndzones: true,
          legend: {
            isVisible: false
          },
          valueLabels: 'hide',
          fittingFunction: 'None',
          axisTitlesVisibilitySettings: {
            x: false,
            yLeft: false,
            yRight: false
          },
          tickLabelsVisibilitySettings: {
            x: true,
            yLeft: true,
            yRight: true
          },
          labelsOrientation: {
            x: 0,
            yLeft: 0,
            yRight: 0
          },
          gridlinesVisibilitySettings: {
            x: true,
            yLeft: true,
            yRight: true
          },
          preferredSeriesType: seriesType,
          layers: [{
            layerId: 'layer1',
            accessors: ['7327df72-9def-4642-a72d-dc2b0790d5f9'],
            position: 'top',
            seriesType,
            showGridlines: false,
            layerType: 'data',
            xAccessor: '953f9efc-fbf6-44e0-a450-c645d2b5ec22'
          }]
        },
        query: {
          query: '',
          language: 'kuery'
        },
        filters: [],
        datasourceStates: {
          formBased: {
            layers: {
              layer1: {
                columns: {
                  '953f9efc-fbf6-44e0-a450-c645d2b5ec22': {
                    label: '@timestamp',
                    dataType: 'date',
                    operationType: 'date_histogram',
                    sourceField: '@timestamp',
                    isBucketed: true,
                    scale: 'interval',
                    params: {
                      interval: interval === null || interval === void 0 ? void 0 : interval.expression,
                      includeEmptyRows: true,
                      dropPartials: false
                    }
                  },
                  '7327df72-9def-4642-a72d-dc2b0790d5f9': {
                    label: _i18n.i18n.translate('xpack.ml.explorer.alerts.totalAlerts', {
                      defaultMessage: 'Total alerts'
                    }),
                    dataType: 'number',
                    operationType: 'count',
                    isBucketed: false,
                    scale: 'ratio',
                    sourceField: '___records___',
                    params: {
                      emptyAsNull: false,
                      format: {
                        id: 'number',
                        params: {
                          decimals: 0,
                          compact: true
                        }
                      }
                    }
                  }
                },
                columnOrder: ['953f9efc-fbf6-44e0-a450-c645d2b5ec22', '7327df72-9def-4642-a72d-dc2b0790d5f9'],
                incompleteColumns: {},
                sampling: 1
              }
            }
          },
          indexpattern: {
            layers: {}
          },
          textBased: {
            layers: {}
          }
        }
      }
    };
  }, [interval === null || interval === void 0 ? void 0 : interval.expression, seriesType]);
  if (!interval) return null;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        padding-left: ${_constants.Y_AXIS_LABEL_WIDTH - 45}px;
        height: 120px;
        width: 100%;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: "mlExplorerAlertsPreview",
    style: {
      height: 120
    },
    timeRange: timeRange,
    attributes: attributes,
    renderMode: 'view',
    executionContext: {
      type: 'ml_overall_alert_preview_chart',
      name: 'Anomaly detection alert preview chart'
    },
    disableTriggers: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }));
};
exports.AnomalyDetectionAlertsOverviewChart = AnomalyDetectionAlertsOverviewChart;