"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRowMessagesPane = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _kibana = require("../../../../../contexts/kibana");
var _common = require("../../../../common");
var _job_messages = require("../../../../../components/job_messages");
var _toast_notification_service = require("../../../../../services/toast_notification_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/analytics_list/expanded_row_messages_pane.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExpandedRowMessagesPane = ({
  analyticsId,
  dataTestSubj
}) => {
  const mlApi = (0, _kibana.useMlApi)();
  const {
    euiTheme: {
      size
    }
  } = (0, _eui.useEuiTheme)();
  const cssOverride = (0, _react.useMemo)(() => (0, _react2.css)({
    padding: `0 ${size.s} ${size.s} ${size.s}`,
    '.euiTable': {
      backgroundColor: 'transparent'
    }
  }), [size.s]);
  const [messages, setMessages] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [errorMessage, setErrorMessage] = (0, _react.useState)('');
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const getMessages = (0, _react.useCallback)(async () => {
    try {
      setIsLoading(true);
      const messagesResp = await mlApi.dataFrameAnalytics.getAnalyticsAuditMessages(analyticsId);
      setIsLoading(false);
      setMessages(messagesResp);
    } catch (error) {
      setIsLoading(false);
      toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.dfAnalyticsList.analyticsDetails.messagesPane.errorToastMessageTitle', {
        defaultMessage: 'Error loading job messages'
      }));
      setErrorMessage(_i18n.i18n.translate('xpack.ml.dfAnalyticsList.analyticsDetails.messagesPane.errorMessage', {
        defaultMessage: 'Messages could not be loaded'
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    getMessages();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _common.useRefreshAnalyticsList)({
    onRefresh: getMessages
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    css: cssOverride,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_job_messages.JobMessages, {
    messages: messages,
    loading: isLoading,
    error: errorMessage,
    refreshMessage: getMessages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }));
};
exports.ExpandedRowMessagesPane = ExpandedRowMessagesPane;