"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurationStepForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _mlRuntimeFieldUtils = require("@kbn/ml-runtime-field-utils");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _mlDataGrid = require("@kbn/ml-data-grid");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _mlFieldStatsFlyout = require("@kbn/ml-field-stats-flyout");
var _kibana = require("../../../../../contexts/kibana");
var _new_job_capabilities_service_analytics = require("../../../../../services/new_job_capabilities/new_job_capabilities_service_analytics");
var _ml = require("../../../../../contexts/ml");
var _get_scatterplot_matrix_legend_type = require("../../../../common/get_scatterplot_matrix_legend_type");
var _shared = require("../shared");
var _state = require("../../../analytics_management/hooks/use_create_analytics_form/state");
var _form_options_validation = require("./form_options_validation");
var _page = require("../../page");
var _continue_button = require("../continue_button");
var _job_type = require("./job_type");
var _supported_fields_message = require("./supported_fields_message");
var _analysis_fields_table = require("./analysis_fields_table");
var _hooks = require("../../hooks");
var _exploration_query_bar = require("../../../analytics_exploration/components/exploration_query_bar");
var _use_saved_search = require("./use_saved_search");
var _scatterplot_matrix = require("../../../../../components/scatterplot_matrix");
var _runtime_mappings = require("../runtime_mappings");
var _index_permissions_callout = require("../index_permissions_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/configuration_step/configuration_step_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const runtimeMappingKey = 'runtime_mapping';
const notIncludedReason = 'field not in includes list';
const requiredFieldsErrorText = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.requiredFieldsErrorMessage', {
  defaultMessage: 'At least one field must be included in the analysis in addition to the dependent variable.'
});
function getIndexDataQuery(savedSearchQuery, jobConfigQuery) {
  // Return `undefined` if savedSearchQuery itself is `undefined`, meaning it hasn't been initialized yet.
  if (savedSearchQuery === undefined) {
    return;
  }
  return savedSearchQuery !== null ? savedSearchQuery : jobConfigQuery;
}
function getRuntimeDepVarOptions(jobType, runtimeMappings) {
  const runtimeOptions = [];
  Object.keys(runtimeMappings).forEach(id => {
    const field = runtimeMappings[id];
    if ((0, _mlRuntimeFieldUtils.isRuntimeField)(field) && (0, _form_options_validation.shouldAddAsDepVarOption)(id, field.type, jobType)) {
      runtimeOptions.push({
        label: id,
        field: {
          id,
          type: field.type
        }
      });
    }
  });
  return runtimeOptions;
}
const ConfigurationStepForm = ({
  actions,
  isClone,
  state,
  setCurrentStep,
  sourceDataViewTitle
}) => {
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const toastNotifications = services.notifications.toasts;
  const mlApi = (0, _kibana.useMlApi)();
  const newJobCapsServiceAnalytics = (0, _new_job_capabilities_service_analytics.useNewJobCapsServiceAnalytics)();
  const {
    selectedDataView,
    selectedSavedSearch
  } = (0, _ml.useDataSource)();
  const {
    savedSearchQuery,
    savedSearchQueryStr
  } = (0, _use_saved_search.useSavedSearch)();
  const [fieldOptionsFetchFail, setFieldOptionsFetchFail] = (0, _react.useState)(false);
  const [loadingDepVarOptions, setLoadingDepVarOptions] = (0, _react.useState)(false);
  const [dependentVariableFetchFail, setDependentVariableFetchFail] = (0, _react.useState)(false);
  const [dependentVariableOptions, setDependentVariableOptions] = (0, _react.useState)([]);
  const [includesTableItems, setIncludesTableItems] = (0, _react.useState)([]);
  const [fetchingExplainData, setFetchingExplainData] = (0, _react.useState)(false);
  const [maxDistinctValuesError, setMaxDistinctValuesError] = (0, _react.useState)();
  const [unsupportedFieldsError, setUnsupportedFieldsError] = (0, _react.useState)();
  const [noDocsContainMappedFields, setNoDocsContainMappedFields] = (0, _react.useState)(false);
  const [minimumFieldsRequiredMessage, setMinimumFieldsRequiredMessage] = (0, _react.useState)();
  const {
    setEstimatedModelMemoryLimit,
    setFormState
  } = actions;
  const {
    cloneJob,
    estimatedModelMemoryLimit,
    form,
    isJobCreated,
    requestMessages
  } = state;
  const firstUpdate = (0, _react.useRef)(true);
  const {
    dependentVariable,
    includes,
    jobConfigQuery,
    jobConfigQueryLanguage,
    jobConfigQueryString,
    jobType,
    modelMemoryLimit,
    previousJobType,
    requiredFieldsError,
    runtimeMappings,
    previousRuntimeMapping,
    runtimeMappingsUpdated,
    sourceIndex,
    trainingPercent,
    useEstimatedMml
  } = form;
  const isJobTypeWithDepVar = jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION || jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION;
  const dependentVariableEmpty = isJobTypeWithDepVar && dependentVariable === '';
  const hasBasicRequiredFields = jobType !== undefined;
  const hasRequiredAnalysisFields = isJobTypeWithDepVar && dependentVariable !== '' || jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION;
  const [query, setQuery] = (0, _react.useState)({
    query: jobConfigQueryString !== null && jobConfigQueryString !== void 0 ? jobConfigQueryString : '',
    language: jobConfigQueryLanguage !== null && jobConfigQueryLanguage !== void 0 ? jobConfigQueryLanguage : _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY
  });
  const setJobConfigQuery = update => {
    if (update.query) {
      setFormState({
        jobConfigQuery: update.query,
        jobConfigQueryLanguage: update.language,
        jobConfigQueryString: update.queryString
      });
    }
    setQuery({
      query: update.queryString,
      language: update.language
    });
  };
  const indexData = (0, _hooks.useIndexData)(selectedDataView, getIndexDataQuery(savedSearchQuery, jobConfigQuery), toastNotifications, runtimeMappings);
  const indexPreviewProps = {
    ...indexData,
    dataTestSubj: 'mlAnalyticsCreationDataGrid',
    toastNotifications
  };
  const isStepInvalid = dependentVariableEmpty || jobType === undefined || maxDistinctValuesError !== undefined || minimumFieldsRequiredMessage !== undefined || requiredFieldsError !== undefined || unsupportedFieldsError !== undefined || fetchingExplainData;
  const loadDepVarOptions = async (formState, runtimeOptions = []) => {
    setLoadingDepVarOptions(true);
    setMaxDistinctValuesError(undefined);
    try {
      if (selectedDataView !== undefined) {
        const depVarOptions = [];
        let depVarUpdate = formState.dependentVariable;
        // Get fields and filter for supported types for job type
        const {
          fields
        } = newJobCapsServiceAnalytics;
        let resetDependentVariable = true;
        for (const field of fields) {
          if ((0, _form_options_validation.shouldAddAsDepVarOption)(field.id, field.type, jobType)) {
            depVarOptions.push({
              label: field.id,
              field
            });
            if (formState.dependentVariable === field.id) {
              resetDependentVariable = false;
            }
          }
        }
        if ((0, _mlRuntimeFieldUtils.isRuntimeMappings)(formState.runtimeMappings) && Object.keys(formState.runtimeMappings).includes(form.dependentVariable)) {
          resetDependentVariable = false;
          depVarOptions.push({
            label: form.dependentVariable,
            key: `runtime_mapping_${form.dependentVariable}`
          });
        }
        if (resetDependentVariable) {
          depVarUpdate = '';
        }
        setDependentVariableOptions([...runtimeOptions, ...depVarOptions]);
        setLoadingDepVarOptions(false);
        setDependentVariableFetchFail(false);
        setFormState({
          dependentVariable: depVarUpdate
        });
      }
    } catch (e) {
      setLoadingDepVarOptions(false);
      setDependentVariableFetchFail(true);
    }
  };
  const debouncedGetExplainData = (0, _lodash.debounce)(async () => {
    setFetchingExplainData(true);
    const jobTypeChanged = previousJobType !== jobType;
    const shouldUpdateModelMemoryLimit = (!firstUpdate.current || !modelMemoryLimit) && useEstimatedMml === true;
    const shouldUpdateEstimatedMml = !firstUpdate.current || !modelMemoryLimit || estimatedModelMemoryLimit === '';
    if (firstUpdate.current) {
      firstUpdate.current = false;
    }
    const depVarNotIncluded = isJobTypeWithDepVar && includes.length > 0 && includes.includes(dependentVariable) === false;
    // Ensure runtime field is in 'includes' table if it is set as dependent variable
    const depVarIsRuntimeField = depVarNotIncluded && runtimeMappings && Object.keys(runtimeMappings).includes(dependentVariable);
    let formToUse = form;
    if (depVarIsRuntimeField || depVarNotIncluded) {
      formToUse = (0, _lodash.cloneDeep)(form);
      formToUse.includes = [...includes, dependentVariable];
    }
    const {
      success,
      expectedMemory,
      fieldSelection,
      errorMessage,
      noDocsContainMappedFields: noDocsWithFields
    } = await (0, _shared.fetchExplainData)(mlApi, formToUse);
    if (success) {
      if (shouldUpdateEstimatedMml) {
        setEstimatedModelMemoryLimit(expectedMemory);
      }
      const hasRequiredFields = fieldSelection.some(field => field.is_included === true && field.is_required === false);
      const formStateUpdated = {
        ...(shouldUpdateModelMemoryLimit ? {
          modelMemoryLimit: expectedMemory
        } : {}),
        ...(depVarIsRuntimeField || depVarNotIncluded ? {
          includes: formToUse.includes
        } : {}),
        requiredFieldsError: !hasRequiredFields ? requiredFieldsErrorText : undefined
      };
      if (jobTypeChanged) {
        setFieldOptionsFetchFail(false);
        setMaxDistinctValuesError(undefined);
        setUnsupportedFieldsError(undefined);
        setNoDocsContainMappedFields(false);
        setIncludesTableItems(fieldSelection ? fieldSelection : []);
      }
      setFormState(formStateUpdated);
      setFetchingExplainData(false);
    } else {
      const {
        maxDistinctValuesErrorMessage,
        unsupportedFieldsErrorMessage,
        toastNotificationDanger,
        toastNotificationWarning
      } = (0, _form_options_validation.handleExplainErrorMessage)(errorMessage, sourceIndex, jobType);
      if (toastNotificationDanger) {
        toastNotifications.addDanger(toastNotificationDanger);
      }
      if (toastNotificationWarning) {
        toastNotifications.addWarning(toastNotificationWarning);
      }
      const fallbackModelMemoryLimit = jobType !== undefined ? _state.DEFAULT_MODEL_MEMORY_LIMIT[jobType] : _state.DEFAULT_MODEL_MEMORY_LIMIT.outlier_detection;
      setEstimatedModelMemoryLimit(fallbackModelMemoryLimit);
      setFieldOptionsFetchFail(true);
      setMaxDistinctValuesError(maxDistinctValuesErrorMessage);
      setUnsupportedFieldsError(unsupportedFieldsErrorMessage);
      setNoDocsContainMappedFields(noDocsWithFields);
      setFetchingExplainData(false);
      setFormState({
        ...(shouldUpdateModelMemoryLimit ? {
          modelMemoryLimit: fallbackModelMemoryLimit
        } : {})
      });
    }
  }, 300);
  (0, _react.useEffect)(() => {
    setFormState({
      sourceIndex: selectedDataView.title
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const dataViewFieldsTableItems = (0, _react.useMemo)(() => {
    if ((indexData === null || indexData === void 0 ? void 0 : indexData.dataViewFields) !== undefined) {
      return indexData.dataViewFields.map(field => ({
        name: field,
        is_included: false,
        is_required: false
      }));
    }
    return [];
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [`${indexData === null || indexData === void 0 ? void 0 : indexData.dataViewFields}`]);
  (0, _react.useEffect)(() => {
    if (typeof savedSearchQueryStr === 'string') {
      setFormState({
        jobConfigQuery: savedSearchQuery,
        jobConfigQueryString: savedSearchQueryStr
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(savedSearchQuery), savedSearchQueryStr]);
  (0, _react.useEffect)(() => {
    if (isJobTypeWithDepVar) {
      const dataViewRuntimeFields = (0, _mlRuntimeFieldUtils.getCombinedRuntimeMappings)(selectedDataView);
      let runtimeOptions;
      if (dataViewRuntimeFields) {
        runtimeOptions = getRuntimeDepVarOptions(jobType, dataViewRuntimeFields);
      }
      loadDepVarOptions(form, runtimeOptions);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobType]);
  const handleRuntimeUpdate = (0, _react.useCallback)(async () => {
    if (runtimeMappingsUpdated) {
      // Update dependent variable options
      let resetDepVar = false;
      if (isJobTypeWithDepVar) {
        const filteredOptions = dependentVariableOptions.filter(option => {
          var _option$key, _option$key2;
          if (option.label === dependentVariable && (_option$key = option.key) !== null && _option$key !== void 0 && _option$key.includes(runtimeMappingKey)) {
            resetDepVar = true;
          }
          return !((_option$key2 = option.key) !== null && _option$key2 !== void 0 && _option$key2.includes(runtimeMappingKey));
        });
        // Runtime fields have been removed
        if (runtimeMappings === undefined && runtimeMappingsUpdated === true) {
          setDependentVariableOptions(filteredOptions);
        } else if (runtimeMappings) {
          // add to filteredOptions if it's the type supported
          const runtimeOptions = getRuntimeDepVarOptions(jobType, runtimeMappings);
          setDependentVariableOptions([...filteredOptions, ...runtimeOptions]);
        }
      }

      // Update includes - remove previous runtime fields then add supported runtime fields to includes
      const updatedIncludes = includes.filter(field => {
        const isRemovedRuntimeField = previousRuntimeMapping && previousRuntimeMapping[field];
        return !isRemovedRuntimeField;
      });
      if (resetDepVar) {
        setFormState({
          dependentVariable: '',
          includes: updatedIncludes
        });
        setIncludesTableItems(includesTableItems.filter(({
          name
        }) => {
          const isRemovedRuntimeField = previousRuntimeMapping && previousRuntimeMapping[name];
          return !isRemovedRuntimeField;
        }));
      }
      if (!resetDepVar && hasBasicRequiredFields && hasRequiredAnalysisFields) {
        const formCopy = (0, _lodash.cloneDeep)(form);
        // When switching back to step ensure runtime field is in 'includes' table if it is set as dependent variable
        const depVarIsRuntimeField = isJobTypeWithDepVar && runtimeMappings && Object.keys(runtimeMappings).includes(dependentVariable) && formCopy.includes.length > 0 && formCopy.includes.includes(dependentVariable) === false;
        formCopy.includes = depVarIsRuntimeField ? [...updatedIncludes, dependentVariable] : updatedIncludes;
        const {
          success,
          fieldSelection,
          errorMessage,
          noDocsContainMappedFields: noDocsWithFields
        } = await (0, _shared.fetchExplainData)(mlApi, formCopy);
        if (success) {
          // update the field selection table
          const hasRequiredFields = fieldSelection.some(field => field.is_included === true && field.is_required === false);
          let updatedFieldSelection;
          // Update field selection to select supported runtime fields by default. Add those fields to 'includes'.
          if ((0, _mlRuntimeFieldUtils.isRuntimeMappings)(runtimeMappings)) {
            updatedFieldSelection = fieldSelection.map(field => {
              var _field$reason;
              if (runtimeMappings[field.name] !== undefined && field.is_included === false && (_field$reason = field.reason) !== null && _field$reason !== void 0 && _field$reason.includes(notIncludedReason)) {
                updatedIncludes.push(field.name);
                field.is_included = true;
              }
              return field;
            });
          }
          setIncludesTableItems(updatedFieldSelection ? updatedFieldSelection : fieldSelection);
          setMaxDistinctValuesError(undefined);
          setUnsupportedFieldsError(undefined);
          setNoDocsContainMappedFields(noDocsWithFields);
          setFormState({
            includes: updatedIncludes,
            requiredFieldsError: !hasRequiredFields ? requiredFieldsErrorText : undefined
          });
        } else {
          const {
            maxDistinctValuesErrorMessage,
            unsupportedFieldsErrorMessage,
            toastNotificationDanger,
            toastNotificationWarning
          } = (0, _form_options_validation.handleExplainErrorMessage)(errorMessage, sourceIndex, jobType);
          if (toastNotificationDanger) {
            toastNotifications.addDanger(toastNotificationDanger);
          }
          if (toastNotificationWarning) {
            toastNotifications.addWarning(toastNotificationWarning);
          }
          setMaxDistinctValuesError(maxDistinctValuesErrorMessage);
          setUnsupportedFieldsError(unsupportedFieldsErrorMessage);
          setNoDocsContainMappedFields(noDocsWithFields);
        }
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(runtimeMappings)]);
  (0, _react.useEffect)(() => {
    handleRuntimeUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(runtimeMappings)]);
  (0, _react.useEffect)(() => {
    if (hasBasicRequiredFields && hasRequiredAnalysisFields) {
      debouncedGetExplainData();
    }
    return () => {
      debouncedGetExplainData.cancel();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobType, dependentVariable, trainingPercent, JSON.stringify(includes), jobConfigQueryString]);
  const scatterplotMatrixProps = (0, _react.useMemo)(() => ({
    color: isJobTypeWithDepVar ? dependentVariable : undefined,
    fields: includesTableItems.filter(d => d.feature_type === 'numerical' && d.is_included).map(d => d.name),
    index: selectedDataView.title,
    legendType: (0, _get_scatterplot_matrix_legend_type.getScatterplotMatrixLegendType)(jobType),
    searchQuery: jobConfigQuery,
    runtimeMappings,
    dataView: selectedDataView
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [selectedDataView.title, dependentVariable, includesTableItems, isJobTypeWithDepVar, jobConfigQuery, jobType]);

  // Show the Scatterplot Matrix only if
  // - There's more than one suitable field available
  // - The job type is outlier detection, or
  // - The job type is regression or classification and the dependent variable has been set
  const showScatterplotMatrix = (0, _react.useMemo)(() => (jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION || isJobTypeWithDepVar && !dependentVariableEmpty) && scatterplotMatrixProps.fields.length > 1,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [dependentVariableEmpty, jobType, scatterplotMatrixProps.fields.length]);
  const fieldStatsServices = (0, _react.useMemo)(() => {
    const {
      uiSettings,
      data,
      fieldFormats,
      charts
    } = services;
    return {
      uiSettings,
      dataViews: data.dataViews,
      data,
      fieldFormats,
      charts
    };
  }, [services]);

  // Don't render until `savedSearchQuery` has been initialized.
  // `undefined` means uninitialized, `null` means initialized but not used.
  if (savedSearchQuery === undefined) return null;
  const tableItems = includesTableItems.length > 0 && !noDocsContainMappedFields ? includesTableItems : dataViewFieldsTableItems;
  return /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.FieldStatsFlyoutProvider, {
    dataView: selectedDataView,
    fieldStatsServices: fieldStatsServices,
    timeRangeMs: indexData.timeRangeMs,
    dslQuery: jobConfigQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 574,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 580,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.Messages, {
    messages: requestMessages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 581,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_supported_fields_message.SupportedFieldsMessage, {
    jobType: jobType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 582,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_index_permissions_callout.IndexPermissionsCallout, {
    indexName: sourceDataViewTitle,
    docsType: "create",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 583,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_job_type.JobType, {
    type: jobType,
    setFormState: setFormState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 584,
      columnNumber: 9
    }
  }), savedSearchQuery === null && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.sourceQueryLabel', {
      defaultMessage: 'Query'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 586,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_exploration_query_bar.ExplorationQueryBar, {
    dataView: selectedDataView,
    setSearchQuery: setJobConfigQuery,
    query: query,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 592,
      columnNumber: 13
    }
  })), (isClone && cloneJob || !isClone) && /*#__PURE__*/_react.default.createElement(_runtime_mappings.RuntimeMappings, {
    actions: actions,
    state: state,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 599,
      columnNumber: 49
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 602,
        columnNumber: 13
      }
    }, savedSearchQuery !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 604,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.discoverSessionLabel', {
      defaultMessage: 'Discover session'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 610,
        columnNumber: 15
      }
    }, selectedSavedSearch !== null ? selectedSavedSearch.title : selectedDataView.getName())),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 600,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_mlDataGrid.DataGrid, (0, _extends2.default)({}, indexPreviewProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 619,
      columnNumber: 11
    }
  }))), isJobTypeWithDepVar && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 622,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.dependentVariableLabel', {
      defaultMessage: 'Dependent variable'
    }),
    helpText: dependentVariableOptions.length === 0 && dependentVariableFetchFail === false && selectedDataView && _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.dependentVariableOptionsNoNumericalFields', {
      defaultMessage: 'No numeric type fields were found for this data view.'
    }),
    isInvalid: maxDistinctValuesError !== undefined,
    error: [...(dependentVariableFetchFail === true ? [/*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 643,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.dependentVariableOptionsFetchError', {
      defaultMessage: 'There was a problem fetching fields. Please refresh the page and try again.'
    }))] : []), ...(fieldOptionsFetchFail === true && maxDistinctValuesError !== undefined ? [/*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 656,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.dependentVariableMaxDistictValuesError', {
      defaultMessage: 'Invalid. {message}',
      values: {
        message: maxDistinctValuesError
      }
    }))] : [])],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 623,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.OptionListWithFieldStats, {
    fullWidth: true,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.dependentVariableInputAriaLabel', {
      defaultMessage: 'Enter field to be used as dependent variable.'
    }),
    placeholder: jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION ? _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.dependentVariableRegressionPlaceholder', {
      defaultMessage: 'Select the numeric field that you want to predict.'
    }) : _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.dependentVariableClassificationPlaceholder', {
      defaultMessage: 'Select the numeric, categorical, or boolean field that you want to predict.'
    }),
    isDisabled: isJobCreated,
    isLoading: loadingDepVarOptions,
    singleSelection: true,
    options: dependentVariableOptions,
    selectedOptions: dependentVariable ? [{
      label: dependentVariable
    }] : [],
    onChange: selectedOptions => {
      setFormState({
        dependentVariable: selectedOptions[0].label || ''
      });
    },
    isClearable: false,
    isInvalid: dependentVariable === '',
    "data-test-subj": `mlAnalyticsCreateJobWizardDependentVariableSelect${loadingDepVarOptions ? ' loading' : ' loaded'}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 669,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_analysis_fields_table.AnalysisFieldsTable, {
    dependentVariable: dependentVariable,
    includes: includes,
    isJobTypeWithDepVar: isJobTypeWithDepVar,
    minimumFieldsRequiredMessage: minimumFieldsRequiredMessage,
    setMinimumFieldsRequiredMessage: setMinimumFieldsRequiredMessage,
    tableItems: firstUpdate.current ? includesTableItems : tableItems,
    unsupportedFieldsError: unsupportedFieldsError,
    setUnsupportedFieldsError: setUnsupportedFieldsError,
    setFormState: setFormState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 712,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: requiredFieldsError !== undefined,
    error: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.requiredFieldsError', {
      defaultMessage: 'Invalid. {message}',
      values: {
        message: requiredFieldsError
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 723,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 731,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 733,
      columnNumber: 9
    }
  }), showScatterplotMatrix && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "mlAnalyticsCreateJobWizardScatterplotMatrixFormRow",
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.scatterplotMatrixLabel', {
      defaultMessage: 'Scatterplot matrix'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.scatterplotMatrixLabelHelpText', {
      defaultMessage: 'Visualizes the relationships between pairs of selected included fields.'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 736,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 750,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    "data-test-subj": "mlAnalyticsCreateJobWizardScatterplotMatrixPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 752,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_scatterplot_matrix.ScatterplotMatrix, (0, _extends2.default)({}, scatterplotMatrixProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 756,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 758,
      columnNumber: 13
    }
  })), isJobTypeWithDepVar && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.trainingPercentLabel', {
      defaultMessage: 'Training percent'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.trainingPercentHelpText', {
      defaultMessage: 'Defines the percentage of eligible documents that will be used for training.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 762,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    fullWidth: true,
    min: _mlDataFrameAnalyticsUtils.TRAINING_PERCENT_MIN,
    max: _mlDataFrameAnalyticsUtils.TRAINING_PERCENT_MAX,
    step: 1,
    showLabels: true,
    showRange: true,
    showValue: true,
    value: trainingPercent
    // @ts-ignore Property 'value' does not exist on type 'EventTarget' | (EventTarget & HTMLInputElement)
    ,
    onChange: e => setFormState({
      trainingPercent: +e.target.value
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardTrainingPercentSlider",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 775,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 790,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_continue_button.ContinueButton, {
    isDisabled: isStepInvalid,
    onClick: () => {
      setCurrentStep(_page.ANALYTICS_STEPS.ADVANCED);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 791,
      columnNumber: 9
    }
  })));
};
exports.ConfigurationStepForm = ConfigurationStepForm;