"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineDetailsTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/shared/pipeline_details_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PipelineDetailsTitle = ({
  modelId
}) => {
  const {
    services: {
      docLinks: {
        links
      }
    }
  } = (0, _kibana.useMlKibana)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.title', {
    defaultMessage: 'Create a pipeline'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.description",
    defaultMessage: "Build a {pipeline} to use the trained model - {modelId} - for inference.",
    values: {
      modelId: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 24
        }
      }, modelId),
      pipeline: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.ingest.pipelines,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 17
        }
      }, "pipeline")
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.descriptionUsePipelines",
    defaultMessage: "Use {pipelineSimulateLink} or {reindexLink} to pass data into this pipeline. Predictions are stored in the Target field.",
    values: {
      reindexLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.upgradeAssistant.reindexWithPipeline,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 17
        }
      }, "_reindex API"),
      pipelineSimulateLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.apis.simulatePipeline,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 17
        }
      }, "pipeline/_simulate")
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }))));
};
exports.PipelineDetailsTitle = PipelineDetailsTitle;