"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionExpression = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/rule_editor/condition_expression.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for rendering a rule condition numerical expression.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ConditionExpression extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "openAppliesTo", () => {
      this.setState({
        isAppliesToOpen: true,
        isOperatorValueOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "closeAppliesTo", () => {
      this.setState({
        isAppliesToOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "openOperatorValue", () => {
      this.setState({
        isAppliesToOpen: false,
        isOperatorValueOpen: true
      });
    });
    (0, _defineProperty2.default)(this, "closeOperatorValue", () => {
      this.setState({
        isOperatorValueOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "changeAppliesTo", event => {
      const {
        index,
        operator,
        value,
        updateCondition
      } = this.props;
      updateCondition(index, event.target.value, operator, value);
    });
    (0, _defineProperty2.default)(this, "changeOperator", event => {
      const {
        index,
        appliesTo,
        value,
        updateCondition
      } = this.props;
      updateCondition(index, appliesTo, event.target.value, value);
    });
    (0, _defineProperty2.default)(this, "changeValue", event => {
      const {
        index,
        appliesTo,
        operator,
        updateCondition
      } = this.props;
      updateCondition(index, appliesTo, operator, +event.target.value);
    });
    this.state = {
      isAppliesToOpen: false,
      isOperatorValueOpen: false
    };
  }
  renderAppliesToPopover() {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.conditionExpression.appliesToPopoverTitle",
      defaultMessage: "When",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "euiExpression",
      style: {
        width: 200
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "aria-label": _i18n.i18n.translate('xpack.ml.ruleEditor.conditionExpression.appliesToSelectAriaLabel', {
        defaultMessage: 'Applies to'
      }),
      value: this.props.appliesTo,
      onChange: this.changeAppliesTo,
      options: [{
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.ACTUAL,
        text: (0, _utils.appliesToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.ACTUAL)
      }, {
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.TYPICAL,
        text: (0, _utils.appliesToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.TYPICAL)
      }, {
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.DIFF_FROM_TYPICAL,
        text: (0, _utils.appliesToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.DIFF_FROM_TYPICAL)
      }],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 11
      }
    })));
  }
  renderOperatorValuePopover() {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.conditionExpression.operatorValuePopoverTitle",
      defaultMessage: "Is",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "euiExpression",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        maxWidth: 450
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        width: 250
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "aria-label": _i18n.i18n.translate('xpack.ml.ruleEditor.conditionExpression.operatorSelectAriaLabel', {
        defaultMessage: 'Operator'
      }),
      value: this.props.operator,
      onChange: this.changeOperator,
      options: [{
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.LESS_THAN,
        text: (0, _utils.operatorToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.LESS_THAN)
      }, {
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.LESS_THAN_OR_EQUAL,
        text: (0, _utils.operatorToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.LESS_THAN_OR_EQUAL)
      }, {
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.GREATER_THAN,
        text: (0, _utils.operatorToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.GREATER_THAN)
      }, {
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.GREATER_THAN_OR_EQUAL,
        text: (0, _utils.operatorToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.GREATER_THAN_OR_EQUAL)
      }],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        width: 200
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: +this.props.value,
      onChange: this.changeValue,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 15
      }
    })))));
  }
  render() {
    const {
      index,
      appliesTo,
      operator,
      value,
      deleteCondition
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "appliesToPopover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.ruleEditor.conditionExpression.appliesToButtonLabel",
          defaultMessage: "when",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 202,
            columnNumber: 19
          }
        }),
        value: (0, _utils.appliesToText)(appliesTo),
        isActive: this.state.isAppliesToOpen,
        onClick: this.openAppliesTo,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 200,
          columnNumber: 15
        }
      }),
      isOpen: this.state.isAppliesToOpen,
      closePopover: this.closeAppliesTo,
      panelPaddingSize: "s",
      ownFocus: true,
      anchorPosition: "downLeft",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 11
      }
    }, this.renderAppliesToPopover())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "operatorValuePopover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.ruleEditor.conditionExpression.operatorValueButtonLabel",
          defaultMessage: "is {operator}",
          values: {
            operator: (0, _utils.operatorToText)(operator)
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 228,
            columnNumber: 19
          }
        }),
        value: `${value}`,
        isActive: this.state.isOperatorValueOpen,
        onClick: this.openOperatorValue,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 226,
          columnNumber: 15
        }
      }),
      isOpen: this.state.isOperatorValueOpen,
      closePopover: this.closeOperatorValue,
      panelPaddingSize: "s",
      ownFocus: true,
      anchorPosition: "downLeft",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 11
      }
    }, this.renderOperatorValuePopover())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      color: "danger",
      onClick: () => deleteCondition(index),
      iconType: "trash",
      "aria-label": _i18n.i18n.translate('xpack.ml.ruleEditor.conditionExpression.deleteConditionButtonAriaLabel', {
        defaultMessage: 'Delete condition'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 11
      }
    })));
  }
}
exports.ConditionExpression = ConditionExpression;
(0, _defineProperty2.default)(ConditionExpression, "propTypes", {
  index: _propTypes.default.number.isRequired,
  appliesTo: _propTypes.default.oneOf([_mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.ACTUAL, _mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.TYPICAL, _mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.DIFF_FROM_TYPICAL]),
  operator: _propTypes.default.oneOf([_mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.LESS_THAN, _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.LESS_THAN_OR_EQUAL, _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.GREATER_THAN, _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.GREATER_THAN_OR_EQUAL]),
  value: _propTypes.default.number.isRequired,
  updateCondition: _propTypes.default.func.isRequired,
  deleteCondition: _propTypes.default.func.isRequired
});