"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloseJobConfirm = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _model_snapshots_table = require("../model_snapshots_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/model_snapshots/close_job_confirm/close_job_confirm.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CloseJobConfirm = ({
  combinedJobState,
  hideCloseJobModalVisible,
  forceCloseJob
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: combinedJobState === _model_snapshots_table.COMBINED_JOB_STATE.OPEN_AND_RUNNING ? _i18n.i18n.translate('xpack.ml.modelSnapshotTable.closeJobConfirm.stopAndClose.title', {
      defaultMessage: 'Stop datafeed and close job?'
    }) : _i18n.i18n.translate('xpack.ml.modelSnapshotTable.closeJobConfirm.close.title', {
      defaultMessage: 'Close job?'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: hideCloseJobModalVisible,
    onConfirm: forceCloseJob,
    cancelButtonText: _i18n.i18n.translate('xpack.ml.modelSnapshotTable.closeJobConfirm.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: combinedJobState === _model_snapshots_table.COMBINED_JOB_STATE.OPEN_AND_RUNNING ? _i18n.i18n.translate('xpack.ml.modelSnapshotTable.closeJobConfirm.stopAndClose.button', {
      defaultMessage: 'Stop and close'
    }) : _i18n.i18n.translate('xpack.ml.modelSnapshotTable.closeJobConfirm.close.button', {
      defaultMessage: 'Close'
    }),
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, combinedJobState === _model_snapshots_table.COMBINED_JOB_STATE.OPEN_AND_RUNNING && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.modelSnapshotTable.closeJobConfirm.contentOpenAndRunning",
    defaultMessage: "Job is currently open and running.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }), combinedJobState === _model_snapshots_table.COMBINED_JOB_STATE.OPEN_AND_STOPPED && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.modelSnapshotTable.closeJobConfirm.contentOpen",
    defaultMessage: "Job is currently open.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.modelSnapshotTable.closeJobConfirm.content",
    defaultMessage: "Snapshot revert can only happen on jobs which are closed.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })));
};
exports.CloseJobConfirm = CloseJobConfirm;