"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ItemsGridPagination = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/items_grid/items_grid_pagination.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for the pagination controls of the items grid.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getContextMenuItemIcon(menuItemSetting, itemsPerPage) {
  return menuItemSetting === itemsPerPage ? 'check' : 'empty';
}
class ItemsGridPagination extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState({
        isPopoverOpen: !this.state.isPopoverOpen
      });
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "onPageClick", pageNumber => {
      this.props.setActivePage(pageNumber);
    });
    (0, _defineProperty2.default)(this, "onChangeItemsPerPage", pageSize => {
      this.closePopover();
      this.props.setItemsPerPage(pageSize);
    });
    this.state = {
      isPopoverOpen: false
    };
  }
  render() {
    const {
      itemCount,
      itemsPerPage,
      itemsPerPageOptions,
      activePage
    } = this.props;
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "text",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: this.onButtonClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.itemsGrid.itemsPerPageButtonLabel",
      defaultMessage: "Items per page: {itemsPerPage}",
      values: {
        itemsPerPage
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }));
    const pageCount = Math.ceil(itemCount / itemsPerPage);
    const items = itemsPerPageOptions.map(pageSize => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: `${pageSize} items`,
        icon: getContextMenuItemIcon(pageSize, itemsPerPage),
        onClick: () => {
          this.onChangeItemsPerPage(pageSize);
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.itemsGrid.itemsCountLabel",
        defaultMessage: "{pageSize} items",
        values: {
          pageSize
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 11
        }
      }));
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      "data-test-subj": "mlItemsGridPaginationPopover",
      id: "customizablePagination",
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      "data-test-subj": "mlItemsGridPaginationMenuPanel",
      items: items,
      className: "ml-items-grid-page-size-menu",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
      pageCount: pageCount,
      activePage: activePage,
      onPageClick: this.onPageClick,
      "aria-label": _i18n.i18n.translate('xpack.ml.itemsGrid.pagination.ariaLabel', {
        defaultMessage: 'Items grid pagination'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 11
      }
    })));
  }
}
exports.ItemsGridPagination = ItemsGridPagination;
ItemsGridPagination.propTypes = {
  itemCount: _propTypes.default.number.isRequired,
  itemsPerPage: _propTypes.default.number.isRequired,
  itemsPerPageOptions: _propTypes.default.arrayOf(_propTypes.default.number).isRequired,
  setItemsPerPage: _propTypes.default.func.isRequired,
  activePage: _propTypes.default.number.isRequired,
  setActivePage: _propTypes.default.func.isRequired
};