"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSurveyFeedbackURL = exports.FeedBackButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _kibana = require("../../contexts/kibana");
var _ml = require("../../contexts/ml");
var _hooks = require("../node_available_warning/hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/feedback_button/feedback_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KIBANA_VERSION_QUERY_PARAM = 'version';
const KIBANA_DEPLOYMENT_TYPE_PARAM = 'deployment_type';
const SANITIZED_PATH_PARAM = 'path';
const FEEDBACK_BUTTON_DEFAULT_TEXT = _i18n.i18n.translate('xpack.ml.feedbackButton.defaultText', {
  defaultMessage: 'Give feedback'
});
const ANOMALY_DETECTION_FEEDBACK_URL = 'https://ela.st/anomaly-detection-feedback';
const getDeploymentType = (isCloudEnv, isServerlessEnv) => {
  if (isCloudEnv === undefined || isServerlessEnv === undefined) {
    return undefined;
  }
  if (isServerlessEnv) {
    return 'Serverless';
  }
  if (isCloudEnv) {
    return 'Elastic Cloud';
  }
  return 'Self-Managed';
};
const getSurveyFeedbackURL = ({
  formUrl,
  kibanaVersion,
  sanitizedPath,
  isCloudEnv,
  isServerlessEnv
}) => {
  const deploymentType = getDeploymentType(isCloudEnv, isServerlessEnv);
  const url = new URL(formUrl);
  if (kibanaVersion) {
    url.searchParams.append(KIBANA_VERSION_QUERY_PARAM, kibanaVersion);
  }
  if (deploymentType) {
    url.searchParams.append(KIBANA_DEPLOYMENT_TYPE_PARAM, deploymentType);
  }
  if (sanitizedPath) {
    url.searchParams.append(SANITIZED_PATH_PARAM, sanitizedPath);
  }
  return url.href;
};
exports.getSurveyFeedbackURL = getSurveyFeedbackURL;
const FeedBackButton = ({
  jobIds
}) => {
  const {
    services: {
      kibanaVersion
    }
  } = (0, _kibana.useMlKibana)();
  const {
    isCloud: isCloudEnv
  } = (0, _hooks.useCloudCheck)();
  // ML does not have an explicit isServerless flag,
  // it does however have individual feature flags which are set depending
  // whether the environment is serverless or not.
  // showNodeInfo will always be false in a serverless environment
  // and true in a non-serverless environment.
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const href = (0, _react.useMemo)(() => {
    if (jobIds.length === 0) {
      return;
    }
    return getSurveyFeedbackURL({
      formUrl: ANOMALY_DETECTION_FEEDBACK_URL,
      kibanaVersion,
      isCloudEnv,
      isServerlessEnv: showNodeInfo === false,
      sanitizedPath: window.location.pathname
    });
  }, [isCloudEnv, jobIds.length, kibanaVersion, showNodeInfo]);
  if (jobIds.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": FEEDBACK_BUTTON_DEFAULT_TEXT,
    href: href,
    size: "s",
    iconType: 'popout',
    iconSide: "right",
    target: "_blank",
    "data-test-subj": 'mlFeatureFeedbackButton',
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, FEEDBACK_BUTTON_DEFAULT_TEXT);
};
exports.FeedBackButton = FeedBackButton;