"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statusToEuiIconType = exports.defaultIconType = exports.Callout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlValidators = require("@kbn/ml-validators");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/callout/callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const defaultIconType = exports.defaultIconType = 'question';
const statusToEuiColor = status => {
  switch (status) {
    case _mlValidators.VALIDATION_STATUS.INFO:
      return 'primary';
    case _mlValidators.VALIDATION_STATUS.ERROR:
      return 'danger';
    default:
      return status;
  }
};
const statusToEuiIconType = status => {
  switch (status) {
    case _mlValidators.VALIDATION_STATUS.INFO:
      return 'info';
    case _mlValidators.VALIDATION_STATUS.ERROR:
      return 'cross';
    case _mlValidators.VALIDATION_STATUS.SUCCESS:
      return 'check';
    case _mlValidators.VALIDATION_STATUS.WARNING:
      return 'warning';
    default:
      return status;
  }
};
exports.statusToEuiIconType = statusToEuiIconType;
const Link = ({
  url
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: url,
  target: "_BLANK",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 44,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.validateJob.learnMoreLinkText",
  defaultMessage: "Learn more",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 5
  }
}));
const Message = ({
  text,
  url
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, text, " ", url && /*#__PURE__*/_react.default.createElement(Link, {
  url: url,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 20
  }
}));
const Callout = ({
  heading,
  status,
  text,
  url
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  "data-test-subj": `mlValidationCallout ${status}`
  // @ts-ignore
  ,
  color: statusToEuiColor(status),
  size: "s",
  title: heading || /*#__PURE__*/_react.default.createElement(Message, {
    text: text,
    url: url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 25
    }
  }),
  iconType: status ? statusToEuiIconType(status) : defaultIconType,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 57,
    columnNumber: 5
  }
}, heading && /*#__PURE__*/_react.default.createElement(Message, {
  text: text,
  url: url,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 19
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 67,
    columnNumber: 5
  }
}));
exports.Callout = Callout;