"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMultiBucketAggregate = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Type guard to validate multi bucket aggregate format.
 *
 * @template TBucket
 * @param {unknown} arg - The item to be checked.
 * @returns {arg is estypes.AggregationsMultiBucketAggregateBase<TBucket>}
 */
const isMultiBucketAggregate = arg => {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['buckets']);
};
exports.isMultiBucketAggregate = isMultiBucketAggregate;