"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsTableNoIndicesContent = exports.MetricsTableLoadingContent = exports.MetricsTableEmptyIndicesContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _empty_states = require("../../../empty_states");
var _no_results_dark = _interopRequireDefault(require("./assets/no_results_dark.svg"));
var _no_results_light = _interopRequireDefault(require("./assets/no_results_light.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/metrics_data_access/public/components/infrastructure_node_metrics_tables/shared/components/no_data_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MetricsTableLoadingContent = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": "metricsTableLoadingContent",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoMetrics",
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 11
    }
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.metricsData.metricsTable.loadingContentTitle",
    defaultMessage: "Loading metrics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 3
  }
});
exports.MetricsTableLoadingContent = MetricsTableLoadingContent;
const MetricsTableNoIndicesContent = () => {
  const integrationsLinkProps = (0, _public.useLinkProps)({
    app: 'integrations',
    pathname: 'browse'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "metricsTableLoadingContent",
    iconType: "logoMetrics",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 14
      }
    }, _empty_states.noMetricIndicesPromptTitle),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 13
      }
    }, _empty_states.noMetricIndicesPromptDescription),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      "data-test-subj": "infraMetricsTableNoIndicesContentButton",
      color: "primary",
      fill: true
    }, integrationsLinkProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }), _empty_states.noMetricIndicesPromptPrimaryActionTitle),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  });
};
exports.MetricsTableNoIndicesContent = MetricsTableNoIndicesContent;
const MetricsTableEmptyIndicesContent = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.metricsData.metricsTable.emptyIndicesPromptTimeRangeHintTitle",
      defaultMessage: "Expand your time range",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.metricsData.metricsTable.emptyIndicesPromptTimeRangeHintDescription",
      defaultMessage: "Try searching over a longer period of time.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.metricsData.metricsTable.emptyIndicesPromptQueryHintTitle",
      defaultMessage: "Adjust your query",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.metricsData.metricsTable.emptyIndicesPromptQueryHintDescription",
      defaultMessage: "Try searching for a different combination of terms.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }))),
    color: "subdued",
    "data-test-subj": "metricsTableEmptyIndicesContent",
    icon: /*#__PURE__*/_react.default.createElement(NoResultsIllustration, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 13
      }
    }),
    layout: "horizontal",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.metricsData.metricsTable.emptyIndicesPromptTitle",
      defaultMessage: "No results match your search criteria",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    })),
    titleSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  });
};
exports.MetricsTableEmptyIndicesContent = MetricsTableEmptyIndicesContent;
const NoResultsIllustration = () => {
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const illustration = colorMode === _eui.COLOR_MODES_STANDARD.dark ? _no_results_dark.default : _no_results_light.default;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: noResultsIllustrationAlternativeText,
    size: "fullWidth",
    src: illustration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 5
    }
  });
};
const noResultsIllustrationAlternativeText = _i18n.i18n.translate('xpack.metricsData.metricsTable.noResultsIllustrationAlternativeText', {
  defaultMessage: 'A magnifying glass with an exclamation mark'
});