"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapApp = void 0;
var _reactRedux = require("react-redux");
var _map_app = require("./map_app");
var _ui_selectors = require("../../../selectors/ui_selectors");
var _map_selectors = require("../../../selectors/map_selectors");
var _actions = require("../../../actions");
var _ui = require("../../../reducers/ui");
var _non_serializable_instances = require("../../../reducers/non_serializable_instances");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    isFullScreen: (0, _ui_selectors.getIsFullScreen)(state),
    isOpenSettingsDisabled: (0, _ui_selectors.getFlyoutDisplay)(state) !== _ui.FLYOUT_STATE.NONE,
    isSaveDisabled: (0, _map_selectors.hasDirtyState)(state),
    inspectorAdapters: (0, _non_serializable_instances.getInspectorAdapters)(state),
    nextIndexPatternIds: (0, _map_selectors.getQueryableUniqueIndexPatternIds)(state),
    flyoutDisplay: (0, _ui_selectors.getFlyoutDisplay)(state),
    filters: (0, _map_selectors.getFilters)(state),
    query: (0, _map_selectors.getQuery)(state),
    timeFilters: (0, _map_selectors.getTimeFilters)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    setQuery: ({
      forceRefresh,
      filters,
      query,
      timeFilters,
      searchSessionId
    }) => {
      dispatch((0, _actions.setQuery)({
        filters,
        query,
        timeFilters,
        forceRefresh,
        searchSessionId
      }));
    },
    enableFullScreen: () => dispatch((0, _actions.enableFullScreen)()),
    openMapSettings: () => dispatch((0, _actions.openMapSettings)()),
    setExecutionContext: executionContext => dispatch((0, _actions.setExecutionContext)(executionContext))
  };
}
const connectedComponent = exports.MapApp = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_map_app.MapApp);