"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getControlledBy = getControlledBy;
exports.mapEmbeddableFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _publishes_settings = require("@kbn/presentation-containers/interfaces/publishes_settings");
var _presentationContainers = require("@kbn/presentation-containers");
var _constants = require("../../common/constants");
var _map_page = require("../routes/map_page");
var _initialize_redux_sync = require("./initialize_redux_sync");
var _library_transforms = require("./library_transforms");
var _kibana_services = require("../kibana_services");
var _initialize_action_handlers = require("./initialize_action_handlers");
var _map_container = require("../connected_components/map_container");
var _wait_until_time_layers_load = require("../routes/map_page/map_app/wait_until_time_layers_load");
var _initialize_cross_panel_actions = require("./initialize_cross_panel_actions");
var _initialize_data_views = require("./initialize_data_views");
var _initialize_fetch = require("./initialize_fetch");
var _initialize_edit_api = require("./initialize_edit_api");
var _types = require("./map_renderer/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/react_embeddable/map_react_embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getControlledBy(id) {
  return `mapEmbeddablePanel${id}`;
}
const mapEmbeddableFactory = exports.mapEmbeddableFactory = {
  type: _constants.MAP_SAVED_OBJECT_TYPE,
  buildEmbeddable: async ({
    initialState,
    finalizeApi,
    parentApi,
    uuid
  }) => {
    var _getEmbeddableEnhance, _dynamicActionsManage3;
    const state = initialState.rawState;
    const savedMap = new _map_page.SavedMap({
      mapEmbeddableState: state
    });
    await savedMap.whenReady();

    // eslint bug, eslint thinks api is never reassigned even though it is
    // eslint-disable-next-line prefer-const
    let api;
    const getApi = () => api;
    const sharingSavedObjectProps = savedMap.getSharingSavedObjectProps();
    const spaces = (0, _kibana_services.getSpacesApi)();
    const controlledBy = getControlledBy(uuid);
    const titleManager = (0, _presentationPublishing.initializeTitleManager)(state);
    const timeRangeManager = (0, _presentationPublishing.initializeTimeRangeManager)(state);
    const dynamicActionsManager = (_getEmbeddableEnhance = (0, _kibana_services.getEmbeddableEnhanced)()) === null || _getEmbeddableEnhance === void 0 ? void 0 : _getEmbeddableEnhance.initializeEmbeddableDynamicActions(uuid, () => titleManager.api.title$.getValue(), initialState);
    const maybeStopDynamicActions = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.startDynamicActions();
    const defaultTitle$ = new _rxjs.BehaviorSubject(savedMap.getAttributes().title);
    const defaultDescription$ = new _rxjs.BehaviorSubject(savedMap.getAttributes().description);
    const reduxSync = (0, _initialize_redux_sync.initializeReduxSync)({
      savedMap,
      state,
      syncColors$: (0, _publishes_settings.apiPublishesSettings)(parentApi) ? parentApi.settings.syncColors$ : undefined,
      uuid
    });
    const actionHandlers = (0, _initialize_action_handlers.initializeActionHandlers)(getApi);
    const crossPanelActions = (0, _initialize_cross_panel_actions.initializeCrossPanelActions)({
      controlledBy,
      getActionContext: actionHandlers.getActionContext,
      getApi,
      state,
      savedMap,
      uuid
    });
    function getLatestState() {
      var _dynamicActionsManage;
      return {
        ...state,
        ...timeRangeManager.getLatestState(),
        ...titleManager.getLatestState(),
        ...((_dynamicActionsManage = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.getLatestState()) !== null && _dynamicActionsManage !== void 0 ? _dynamicActionsManage : {}),
        ...crossPanelActions.getLatestState(),
        ...reduxSync.getLatestState()
      };
    }
    function serializeByReference(libraryId) {
      return {
        rawState: (0, _library_transforms.getByReferenceState)(getLatestState(), libraryId),
        references: []
      };
    }
    function serializeByValue() {
      return {
        rawState: (0, _library_transforms.getByValueState)(getLatestState(), savedMap.getAttributes()),
        references: []
      };
    }
    function serializeState() {
      const savedObjectId = savedMap.getSavedObjectId();
      return savedObjectId ? serializeByReference(savedObjectId) : serializeByValue();
    }
    const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
      uuid,
      parentApi,
      serializeState,
      anyStateChange$: (0, _rxjs.merge)(...(dynamicActionsManager ? [dynamicActionsManager.anyStateChange$] : []), crossPanelActions.anyStateChange$, reduxSync.anyStateChange$, titleManager.anyStateChange$, timeRangeManager.anyStateChange$),
      getComparators: () => {
        var _dynamicActionsManage2;
        return {
          ..._initialize_cross_panel_actions.crossPanelActionsComparators,
          ...((_dynamicActionsManage2 = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.comparators) !== null && _dynamicActionsManage2 !== void 0 ? _dynamicActionsManage2 : {
            enhancements: 'skip'
          }),
          ..._initialize_redux_sync.reduxSyncComparators,
          ..._presentationPublishing.titleComparators,
          ..._presentationPublishing.timeRangeComparators,
          attributes: savedMap.getSavedObjectId() !== undefined ? 'skip' : (a, b) => {
            return (a === null || a === void 0 ? void 0 : a.layerListJSON) === (b === null || b === void 0 ? void 0 : b.layerListJSON);
          },
          mapSettings: 'deepEquality',
          savedObjectId: 'skip'
        };
      },
      onReset: async lastSaved => {
        var _lastSaved$rawState;
        dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.reinitializeState((_lastSaved$rawState = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState) !== null && _lastSaved$rawState !== void 0 ? _lastSaved$rawState : {});
        timeRangeManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
        titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
        if (lastSaved) {
          await savedMap.reset(lastSaved.rawState);
        }
      }
    });
    api = finalizeApi({
      defaultTitle$,
      defaultDescription$,
      ...unsavedChangesApi,
      ...timeRangeManager.api,
      ...((_dynamicActionsManage3 = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.api) !== null && _dynamicActionsManage3 !== void 0 ? _dynamicActionsManage3 : {}),
      ...titleManager.api,
      ...reduxSync.api,
      ...(0, _initialize_edit_api.initializeEditApi)(uuid, () => {
        const latestState = getLatestState();
        return latestState.savedObjectId ? (0, _library_transforms.getByReferenceState)(latestState, latestState.savedObjectId) : (0, _library_transforms.getByValueState)(latestState, savedMap.getAttributes());
      }, parentApi, state.savedObjectId),
      ...(0, _library_transforms.initializeLibraryTransforms)(Boolean(savedMap.getSavedObjectId()), serializeByReference, serializeByValue),
      ...(0, _initialize_data_views.initializeDataViews)(savedMap.getStore()),
      serializeState,
      supportedTriggers: () => {
        return [_public.APPLY_FILTER_TRIGGER, _public2.VALUE_CLICK_TRIGGER];
      }
    });
    const unsubscribeFromFetch = (0, _initialize_fetch.initializeFetch)({
      api,
      controlledBy,
      getIsFilterByMapExtent: crossPanelActions.getIsFilterByMapExtent,
      searchSessionMapBuffer: state.mapBuffer,
      store: savedMap.getStore()
    });
    return {
      api,
      Component: () => {
        const [defaultTitle, title, defaultDescription, description] = (0, _presentationPublishing.useBatchedPublishingSubjects)(defaultTitle$, titleManager.api.title$, defaultDescription$, titleManager.api.description$);
        (0, _react.useEffect)(() => {
          return () => {
            crossPanelActions.cleanup();
            reduxSync.cleanup();
            unsubscribeFromFetch();
            maybeStopDynamicActions === null || maybeStopDynamicActions === void 0 ? void 0 : maybeStopDynamicActions.stopDynamicActions();
          };
        }, []);
        return sharingSavedObjectProps && spaces && (sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.outcome) === 'conflict' ? /*#__PURE__*/_react.default.createElement("div", {
          className: "mapEmbeddedError",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 226,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
          iconType: "warning",
          iconColor: "danger",
          "data-test-subj": "embeddable-maps-failure",
          body: spaces.ui.components.getEmbeddableLegacyUrlConflict({
            targetType: _constants.MAP_SAVED_OBJECT_TYPE,
            sourceId: sharingSavedObjectProps.sourceId
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 227,
            columnNumber: 13
          }
        })) : /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
          store: savedMap.getStore(),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 238,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_map_container.MapContainer, {
          onSingleValueTrigger: actionHandlers.onSingleValueTrigger,
          addFilters: (0, _types.isMapRendererApi)(parentApi) && typeof parentApi.hideFilterActions === 'boolean' && parentApi.hideFilterActions || (0, _presentationPublishing.areTriggersDisabled)(api) ? null : actionHandlers.addFilters,
          getFilterActions: actionHandlers.getFilterActions,
          getActionContext: actionHandlers.getActionContext,
          renderTooltipContent: (0, _types.isMapRendererApi)(parentApi) && parentApi.getTooltipRenderer ? parentApi.getTooltipRenderer() : undefined,
          title: title !== null && title !== void 0 ? title : defaultTitle,
          description: description !== null && description !== void 0 ? description : defaultDescription,
          waitUntilTimeLayersLoad$: (0, _wait_until_time_layers_load.waitUntilTimeLayersLoad$)(savedMap.getStore()),
          isSharable: (0, _types.isMapRendererApi)(parentApi) && typeof parentApi.isSharable === 'boolean' ? parentApi.isSharable : true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 239,
            columnNumber: 13
          }
        }));
      }
    };
  }
};