"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpatialJoinPopoverContent = SpatialJoinPopoverContent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana_services = require("../../../../../kibana_services");
var _index_pattern_util = require("../../../../../index_pattern_util");
var _geo_index_pattern_select = require("../../../../../components/geo_index_pattern_select");
var _geo_field_select = require("../../../../../components/geo_field_select");
var _input_strings = require("../../../../input_strings");
var _spatial_join_wizard = require("../../../../../classes/layers/wizards/spatial_join_wizard");
var _join_sources = require("../../../../../classes/sources/join_sources");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/edit_layer_panel/join_editor/resources/spatial_join_expression/spatial_join_popover_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SpatialJoinPopoverContent(props) {
  const [rightDataView, setRightDataView] = (0, _react.useState)(undefined);
  const [rightGeoFields, setRightGeoFields] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [unableToLoadDataView, setUnableToLoadDataView] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (props.sourceDescriptor.indexPatternId === undefined) {
      return;
    }
    let ignore = false;
    setIsLoading(true);
    (0, _kibana_services.getIndexPatternService)().get(props.sourceDescriptor.indexPatternId).then(dataView => {
      if (!ignore) {
        setIsLoading(false);
        setRightDataView(dataView);
        setRightGeoFields((0, _index_pattern_util.getGeoFields)(dataView.fields));
      }
    }).catch(err => {
      if (!ignore) {
        setIsLoading(false);
        setUnableToLoadDataView(true);
      }
    });
    return () => {
      ignore = true;
    };
    // only run on mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const dataViewCallout = unableToLoadDataView ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.maps.spatialJoinExpression.noDataViewTitle', {
    defaultMessage: 'Unable to load data view {dataViewId}.',
    values: {
      dataViewId: props.sourceDescriptor.indexPatternId
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  })) : null;
  const geoFieldSelect = rightDataView ? /*#__PURE__*/_react.default.createElement(_geo_field_select.GeoFieldSelect, {
    value: props.sourceDescriptor.geoField ? props.sourceDescriptor.geoField : '',
    onChange: geoField => {
      if (!geoField) {
        return;
      }
      props.onSourceDescriptorChange({
        ...props.sourceDescriptor,
        geoField
      });
    },
    geoFields: rightGeoFields,
    isClearable: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }) : null;
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.maps.spatialJoinExpression.popoverTitle', {
    defaultMessage: 'Configure spatial join'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _input_strings.inputStrings.relationshipLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_spatial_join_wizard.RelationshipExpression, {
    distance: typeof props.sourceDescriptor.distance === 'number' ? props.sourceDescriptor.distance : _join_sources.DEFAULT_WITHIN_DISTANCE,
    onDistanceChange: distance => {
      props.onSourceDescriptorChange({
        ...props.sourceDescriptor,
        distance
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  })), dataViewCallout, /*#__PURE__*/_react.default.createElement(_geo_index_pattern_select.GeoIndexPatternSelect, {
    dataView: rightDataView,
    onChange: dataView => {
      setUnableToLoadDataView(false);
      setRightDataView(dataView);
      const geoFields = (0, _index_pattern_util.getGeoFields)(dataView.fields);
      setRightGeoFields(geoFields);
      props.onSourceDescriptorChange({
        ...props.sourceDescriptor,
        indexPatternId: dataView.id,
        geoField: geoFields.length ? geoFields[0].name : undefined
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }), geoFieldSelect));
}