"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddLayerPanel = void 0;
var _reactRedux = require("react-redux");
var _view = require("./view");
var _ui = require("../../reducers/ui");
var _actions = require("../../actions");
var _map_selectors = require("../../selectors/map_selectors");
var _constants = require("../../../common/constants");
var _ui_selectors = require("../../selectors/ui_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    hasPreviewLayers: (0, _map_selectors.hasPreviewLayers)(state),
    autoOpenLayerWizardId: (0, _ui_selectors.getAutoOpenLayerWizardId)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    addPreviewLayers: layerDescriptors => {
      dispatch((0, _actions.addPreviewLayers)(layerDescriptors));
    },
    addLayersAndClose: () => {
      dispatch((0, _actions.updateFlyout)(_ui.FLYOUT_STATE.NONE));
      dispatch((0, _actions.promotePreviewLayers)());
    },
    addLayersAndContinue: () => {
      dispatch((0, _actions.setFirstPreviewLayerToSelectedLayer)());
      dispatch((0, _actions.updateFlyout)(_ui.FLYOUT_STATE.LAYER_PANEL));
      dispatch((0, _actions.promotePreviewLayers)());
    },
    closeFlyout: () => {
      dispatch((0, _actions.updateFlyout)(_ui.FLYOUT_STATE.NONE));
      dispatch((0, _actions.removePreviewLayers)());
    },
    enableEditMode: () => {
      dispatch((0, _actions.setEditLayerToSelectedLayer)());
      dispatch((0, _actions.setDrawMode)(_constants.DRAW_MODE.DRAW_SHAPES));
    },
    clearAutoOpenLayerWizardId: () => {
      dispatch((0, _actions.setAutoOpenLayerWizardId)(''));
    }
  };
}
const connected = exports.AddLayerPanel = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps, null, {
  forwardRef: true
})(_view.AddLayerPanel);