"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidatedRange = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/validated_range.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function isWithinRange(min, max, value) {
  if (value >= min && value <= max) {
    return true;
  }
  return false;
}

// TODO move to EUI
// Wrapper around EuiRange that ensures onChange callback is only called when value is number and within min/max
class ValidatedRange extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {});
    (0, _defineProperty2.default)(this, "_onRangeChange", e => {
      const sanitizedValue = parseFloat(e.target.value, 10);
      let newValue = isNaN(sanitizedValue) ? '' : sanitizedValue;
      // work around for https://github.com/elastic/eui/issues/1458
      // TODO remove once above EUI issue is resolved
      newValue = Number(newValue);
      const isValid = isWithinRange(this.props.min, this.props.max, newValue) ? true : false;
      this.setState({
        value: newValue,
        isValid
      });
      if (isValid) {
        this.props.onChange(newValue);
      }
    });
  }
  static getDerivedStateFromProps(nextProps, prevState) {
    if (nextProps.value !== prevState.prevValue) {
      return {
        value: nextProps.value,
        prevValue: nextProps.value,
        isValid: isWithinRange(nextProps.min, nextProps.max, nextProps.value)
      };
    }
    return null;
  }
  render() {
    const {
      max,
      min,
      value,
      // eslint-disable-line no-unused-vars
      onChange,
      // eslint-disable-line no-unused-vars
      ...rest
    } = this.props;
    const rangeInput = /*#__PURE__*/_react.default.createElement(_eui.EuiRange, (0, _extends2.default)({
      min: min,
      max: max,
      value: this.state.value.toString(),
      onChange: this._onRangeChange
    }, rest, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 7
      }
    }));
    if (!this.state.isValid) {
      // Wrap in div so single child is returned.
      // common pattern is to put ValidateRange as a child to EuiFormRow and EuiFormRow expects a single child
      return /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 9
        }
      }, rangeInput, /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.validatedRange.rangeErrorMessage",
        defaultMessage: "Must be between {min} and {max}",
        values: {
          min,
          max
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 13
        }
      })));
    }
    return rangeInput;
  }
}
exports.ValidatedRange = ValidatedRange;