"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorIcon = VectorIcon;
var _react = _interopRequireDefault(require("react"));
var _circle_icon = require("./circle_icon");
var _line_icon = require("./line_icon");
var _polygon_icon = require("./polygon_icon");
var _symbol_icon = require("./symbol_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/legend/vector_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function VectorIcon({
  borderStyle = {},
  fillColor,
  isPointsOnly,
  isLinesOnly,
  strokeColor,
  symbolId,
  svg
}) {
  if (isLinesOnly) {
    const style = {
      stroke: strokeColor,
      strokeWidth: '4px',
      ...borderStyle
    };
    return /*#__PURE__*/_react.default.createElement(_line_icon.LineIcon, {
      style: style,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 12
      }
    });
  }
  const style = {
    stroke: strokeColor,
    strokeWidth: '1px',
    fill: fillColor,
    ...borderStyle
  };
  if (!isPointsOnly) {
    return /*#__PURE__*/_react.default.createElement(_polygon_icon.PolygonIcon, {
      style: style,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 12
      }
    });
  }
  if (!symbolId) {
    return /*#__PURE__*/_react.default.createElement(_circle_icon.CircleIcon, {
      style: style,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 12
      }
    });
  }
  if (svg) {
    return /*#__PURE__*/_react.default.createElement(_symbol_icon.SymbolIcon, {
      key: `${symbolId}${fillColor}${strokeColor}`,
      symbolId: symbolId,
      fill: fillColor,
      stroke: strokeColor,
      style: borderStyle,
      svg: svg,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 7
      }
    });
  }
  return null;
}