"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _single_field_select = require("../../../components/single_field_select");
var _kibana_services = require("../../../kibana_services");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _index_pattern_util = require("../../../index_pattern_util");
var _i18n_getters = require("../../../../common/i18n_getters");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_pew_pew_source/create_source_editor.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class CreateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isLoadingIndexPattern: false,
      indexPattern: undefined,
      indexPatternId: undefined,
      sourceGeoField: undefined,
      destGeoField: undefined,
      indexPatternHasMultipleGeoFields: false
    });
    (0, _defineProperty2.default)(this, "onIndexPatternSelect", indexPatternId => {
      this.setState({
        indexPatternId
      }, this.loadIndexPattern.bind(null, indexPatternId));
    });
    (0, _defineProperty2.default)(this, "loadIndexPattern", indexPatternId => {
      this.setState({
        isLoadingIndexPattern: true,
        indexPattern: undefined,
        sourceGeoField: undefined,
        destGeoField: undefined,
        indexPatternHasMultipleGeoFields: false
      }, this.debouncedLoad.bind(null, indexPatternId));
    });
    (0, _defineProperty2.default)(this, "debouncedLoad", _lodash.default.debounce(async indexPatternId => {
      if (!indexPatternId || indexPatternId.length === 0) {
        return;
      }
      let indexPattern;
      try {
        indexPattern = await (0, _kibana_services.getIndexPatternService)().get(indexPatternId);
      } catch (err) {
        // index pattern no longer exists
        return;
      }
      if (!this._isMounted) {
        return;
      }

      // props.indexPatternId may be updated before getIndexPattern returns
      // ignore response when fetched index pattern does not match active index pattern
      if (this.state.indexPatternId !== indexPatternId) {
        return;
      }
      const geoFields = (0, _index_pattern_util.getFieldsWithGeoTileAgg)(indexPattern.fields);
      this.setState({
        isLoadingIndexPattern: false,
        indexPattern: indexPattern,
        indexPatternHasMultipleGeoFields: geoFields.length >= 2
      });
    }, 300));
    (0, _defineProperty2.default)(this, "_onSourceGeoSelect", sourceGeoField => {
      this.setState({
        sourceGeoField
      }, this.previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onDestGeoSelect", destGeoField => {
      this.setState({
        destGeoField
      }, this.previewLayer);
    });
    (0, _defineProperty2.default)(this, "previewLayer", () => {
      const {
        indexPatternId,
        sourceGeoField,
        destGeoField
      } = this.state;
      const sourceConfig = indexPatternId && sourceGeoField && destGeoField ? {
        indexPatternId,
        sourceGeoField,
        destGeoField
      } : null;
      this.props.onSourceConfigChange(sourceConfig);
    });
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidMount() {
    this._isMounted = true;
  }
  _renderGeoSelects() {
    if (!this.state.indexPattern || !this.state.indexPatternHasMultipleGeoFields) {
      return null;
    }
    const fields = this.state.indexPattern ? (0, _index_pattern_util.getFieldsWithGeoTileAgg)(this.state.indexPattern.fields) : undefined;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.pewPew.sourceGeoFieldLabel', {
        defaultMessage: 'Source'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
      placeholder: _i18n.i18n.translate('xpack.maps.source.pewPew.sourceGeoFieldPlaceholder', {
        defaultMessage: 'Select source geo field'
      }),
      value: this.state.sourceGeoField,
      onChange: this._onSourceGeoSelect,
      fields: fields,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.pewPew.destGeoFieldLabel', {
        defaultMessage: 'Destination'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
      placeholder: _i18n.i18n.translate('xpack.maps.source.pewPew.destGeoFieldPlaceholder', {
        defaultMessage: 'Select destination geo field'
      }),
      value: this.state.destGeoField,
      onChange: this._onDestGeoSelect,
      fields: fields,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 11
      }
    })));
  }
  _renderIndexPatternSelect() {
    const IndexPatternSelect = (0, _kibana_services.getIndexPatternSelectComponent)();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: (0, _i18n_getters.getDataViewLabel)(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(IndexPatternSelect, {
      indexPatternId: this.state.indexPatternId,
      onChange: this.onIndexPatternSelect,
      placeholder: (0, _i18n_getters.getDataViewSelectPlaceholder)(),
      fieldTypes: [_constants.ES_GEO_FIELD_TYPE.GEO_POINT],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 9
      }
    }));
  }
  render() {
    let callout;
    if (this.state.indexPattern && !this.state.indexPatternHasMultipleGeoFields) {
      callout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "warning",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.source.pewPew.noSourceAndDestDetails",
        defaultMessage: "Selected data view does not contain source and destination fields.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 13
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 7
      }
    }, callout, this._renderIndexPatternSelect(), this._renderGeoSelects());
  }
}
exports.CreateSourceEditor = CreateSourceEditor;
(0, _defineProperty2.default)(CreateSourceEditor, "propTypes", {
  onSourceConfigChange: _propTypes.default.func.isRequired
});