"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAggDescriptor = createAggDescriptor;
exports.createRegionMapLayerDescriptor = createRegionMapLayerDescriptor;
var _uuid = require("uuid");
var _constants = require("../../../common/constants");
var _vector_style = require("../styles/vector/vector_style");
var _ems_file_source = require("../sources/ems_file_source");
var _vector_layer = require("./vector_layer");
var _vector_style_defaults = require("../styles/vector/vector_style_defaults");
var _color_palettes = require("../styles/color_palettes");
var _get_agg_key = require("../../../common/get_agg_key");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultDynamicProperties = (0, _vector_style_defaults.getDefaultDynamicProperties)();
function createAggDescriptor(metricAgg, metricFieldName) {
  const aggTypeKey = Object.keys(_constants.AGG_TYPE).find(key => {
    return _constants.AGG_TYPE[key] === metricAgg;
  });
  const aggType = aggTypeKey ? _constants.AGG_TYPE[aggTypeKey] : undefined;
  if (!aggType || aggType === _constants.AGG_TYPE.COUNT || !metricFieldName) {
    return {
      type: _constants.AGG_TYPE.COUNT
    };
  } else if (aggType === _constants.AGG_TYPE.PERCENTILE) {
    return {
      type: aggType,
      field: metricFieldName,
      percentile: 50
    };
  } else {
    return {
      type: aggType,
      field: metricFieldName
    };
  }
}
function createRegionMapLayerDescriptor({
  label,
  emsLayerId,
  leftFieldName,
  termsFieldName,
  termsSize,
  colorSchema,
  indexPatternId,
  metricAgg,
  metricFieldName
}) {
  if (!indexPatternId || !emsLayerId || !leftFieldName || !termsFieldName) {
    return null;
  }
  const metricsDescriptor = createAggDescriptor(metricAgg, metricFieldName);
  const joinId = (0, _uuid.v4)();
  const joinKey = (0, _get_agg_key.getJoinAggKey)({
    aggType: metricsDescriptor.type,
    aggFieldName: 'field' in metricsDescriptor ? metricsDescriptor.field : '',
    rightSourceId: joinId
  });
  const colorPallette = _color_palettes.NUMERICAL_COLOR_PALETTES.find(pallette => {
    return pallette.value.toLowerCase() === colorSchema.toLowerCase();
  });
  const termSourceDescriptor = {
    type: _constants.SOURCE_TYPES.ES_TERM_SOURCE,
    id: joinId,
    indexPatternId,
    term: termsFieldName,
    metrics: [metricsDescriptor],
    applyGlobalQuery: true,
    applyGlobalTime: true,
    applyForceRefresh: true
  };
  if (termsSize !== undefined) {
    termSourceDescriptor.size = termsSize;
  }
  return _vector_layer.GeoJsonVectorLayer.createDescriptor({
    label,
    joins: [{
      leftField: leftFieldName,
      right: termSourceDescriptor
    }],
    sourceDescriptor: _ems_file_source.EMSFileSource.createDescriptor({
      id: emsLayerId,
      tooltipProperties: ['name', leftFieldName]
    }),
    style: _vector_style.VectorStyle.createDescriptor({
      [_constants.VECTOR_STYLES.FILL_COLOR]: {
        type: _constants.STYLE_TYPE.DYNAMIC,
        options: {
          ...defaultDynamicProperties[_constants.VECTOR_STYLES.FILL_COLOR].options,
          field: {
            name: joinKey,
            origin: _constants.FIELD_ORIGIN.JOIN
          },
          color: colorPallette ? colorPallette.value : 'Yellow to Red',
          type: _constants.COLOR_MAP_TYPE.ORDINAL,
          fieldMetaOptions: {
            ...defaultDynamicProperties[_constants.VECTOR_STYLES.FILL_COLOR].options.fieldMetaOptions,
            isEnabled: false
          }
        }
      }
    })
  });
}