"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineList = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _info_alerts = require("./info_alerts");
var _pipelines_table = require("./pipelines_table");
var _confirm_delete_modal = require("./confirm_delete_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/logstash/public/application/components/pipeline_list/pipeline_list.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class PipelineListUi extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "componentDidMount", () => {
      const {
        isReadOnly,
        licenseService,
        toastNotifications
      } = this.props;
      this.loadPipelines().then(() => {
        if (isReadOnly) {
          toastNotifications.addWarning(licenseService.message);
        }
      });
      this.checkMonitoringAccess();
    });
    (0, _defineProperty2.default)(this, "getEmptyPrompt", () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logstash.pipelineList.noPipelinesTitle",
        defaultMessage: "No pipelines",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 11
        }
      })),
      titleSize: "xs",
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logstash.pipelineList.noPipelinesDescription",
        defaultMessage: "There are no pipelines defined.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 9
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 5
      }
    }));
    (0, _defineProperty2.default)(this, "getErrorPrompt", () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logstash.pipelineList.pipelinesLoadingErrorTitle",
        defaultMessage: "Error",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 11
        }
      })),
      titleSize: "xs",
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logstash.pipelineList.pipelinesLoadingErrorDescription",
        defaultMessage: "Error encountered while loading pipelines.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 9
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 5
      }
    }));
    (0, _defineProperty2.default)(this, "loadPipelines", () => {
      const {
        isReadOnly,
        licenseService,
        pipelinesService,
        toastNotifications,
        intl
      } = this.props;
      this.setState({
        message: /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": "loadingPipelines",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "m",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 11
          }
        }), "\xA0", ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.logstash.pipelineList.pipelinesLoadingMessage",
          defaultMessage: "Loading pipelines\u2026",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 101,
            columnNumber: 11
          }
        }))
      });
      return pipelinesService.getPipelineList().then(pipelines => {
        this.setState({
          isLoading: false,
          isForbidden: false,
          isSelectable: true,
          pipelines
        });
        if (!pipelines.length) {
          this.setState({
            columns: [],
            message: this.getEmptyPrompt(),
            isSelectable: false
          });
        }
      }).catch(err => {
        this.setState({
          isLoading: false,
          message: this.getErrorPrompt()
        });
        return licenseService.checkValidity().then(() => {
          if (err.status === 403) {
            this.setState({
              isLoading: false
            });
            if (isReadOnly) {
              this.setState({
                isForbidden: false
              });
            } else {
              this.setState({
                isForbidden: true
              });
            }
          } else {
            this.setState({
              isForbidden: false
            });
            toastNotifications.addDanger(intl.formatMessage({
              id: 'xpack.logstash.pipelineList.pipelineLoadingErrorNotification',
              defaultMessage: `Couldn't load pipeline. Error: "{errStatusText}".`
            }, {
              errStatusText: err.statusText
            }));
          }
        });
      });
    });
    (0, _defineProperty2.default)(this, "checkMonitoringAccess", () => {
      const {
        clusterService,
        monitoringService
      } = this.props;
      clusterService.isClusterInfoAvailable().then(isAvailable => {
        this.setState({
          showAddRoleAlert: !isAvailable,
          showEnableMonitoringAlert: !monitoringService.isMonitoringEnabled()
        });
      });
    });
    (0, _defineProperty2.default)(this, "renderNoPermissionCallOut", () => {
      const {
        isForbidden,
        isLoading
      } = this.state;
      return isForbidden && !isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "danger",
        iconType: "cross",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.logstash.pipelineList.noPermissionToManageTitle",
          defaultMessage: "You do not have permission to manage Logstash pipelines.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 177,
            columnNumber: 11
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logstash.pipelineList.noPermissionToManageDescription",
        defaultMessage: "Please contact your administrator.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 11
        }
      }))) : null;
    });
    (0, _defineProperty2.default)(this, "hideDeletePipelinesModal", () => {
      this.setState({
        showConfirmDeleteModal: false
      });
    });
    (0, _defineProperty2.default)(this, "showDeletePipelinesModal", () => {
      this.setState({
        showConfirmDeleteModal: true
      });
    });
    (0, _defineProperty2.default)(this, "cancelDeletePipelines", () => {
      this.hideDeletePipelinesModal();
    });
    (0, _defineProperty2.default)(this, "deleteSelectedPipelines", () => {
      this.hideDeletePipelinesModal();
      const {
        licenseService,
        pipelinesService,
        toastNotifications,
        intl
      } = this.props;
      const {
        selection
      } = this.state;
      const numPipelinesSelected = selection.length;
      const pipelineIds = selection.map(({
        id
      }) => id);
      return pipelinesService.deletePipelines(pipelineIds).then(results => {
        const {
          numSuccesses,
          numErrors
        } = results;
        if (numSuccesses === 1 && numErrors === 0) {
          toastNotifications.addSuccess(intl.formatMessage({
            id: 'xpack.logstash.pipelineList.pipelinesSuccessfullyDeletedNotification',
            defaultMessage: 'Deleted "{id}"'
          }, {
            id: selection[0].id
          }));
        } else if (numSuccesses) {
          let text;
          if (numErrors) {
            text = intl.formatMessage({
              id: 'xpack.logstash.pipelineList.pipelinesCouldNotBeDeletedDescription',
              defaultMessage: `But {numErrors, plural, one {# Pipeline} other {# Pipelines}} couldn't be deleted.`
            }, {
              numErrors
            });
          }
          toastNotifications.addSuccess({
            title: intl.formatMessage({
              id: 'xpack.logstash.pipelineList.successfullyDeletedPipelinesNotification',
              defaultMessage: 'Deleted {numSuccesses} out of {numPipelinesSelected, plural, one {# Pipeline} other {# Pipelines}}'
            }, {
              numSuccesses,
              numPipelinesSelected
            }),
            text
          });
        } else if (numErrors) {
          toastNotifications.addError(intl.formatMessage({
            id: 'xpack.logstash.pipelineList.couldNotDeletePipelinesNotification',
            defaultMessage: 'Failed to delete {numErrors, plural, one {# Pipeline} other {# Pipelines}}'
          }, {
            numErrors
          }));
        }
        this.loadPipelines();
      }).catch(err => {
        return licenseService.checkValidity().then(() => toastNotifications.addDanger(err));
      });
    });
    (0, _defineProperty2.default)(this, "onDeleteSelectedPipelines", () => {
      this.showDeletePipelinesModal();
    });
    (0, _defineProperty2.default)(this, "onSelectionChange", selection => this.setState({
      selection
    }));
    this.state = {
      columns: [],
      isForbidden: false,
      isLoading: true,
      isSelectable: false,
      pipelines: [],
      showAddRoleAlert: false,
      showConfirmDeleteModal: false,
      showEnableMonitoringAlert: false,
      selection: []
    };
  }
  render() {
    const {
      clonePipeline,
      createPipeline,
      isReadOnly,
      openPipeline,
      isServerless
    } = this.props;
    const {
      isSelectable,
      message,
      pipelines,
      selection,
      showConfirmDeleteModal
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      "data-test-subj": "pipelineList",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logstash.pipelineList.head",
        defaultMessage: "Pipelines",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 296,
          columnNumber: 13
        }
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logstash.pipelineList.subhead",
        defaultMessage: "Manage logstash event processing and see the result visually",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 299,
          columnNumber: 13
        }
      }),
      bottomBorder: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 9
      }
    }), this.renderNoPermissionCallOut(), /*#__PURE__*/_react.default.createElement(_pipelines_table.PipelinesTable, {
      clonePipeline: clonePipeline,
      createPipeline: createPipeline,
      isReadOnly: isReadOnly,
      isSelectable: isSelectable,
      message: message,
      pipelines: pipelines,
      selection: selection,
      onDeleteSelectedPipelines: this.onDeleteSelectedPipelines,
      onSelectionChange: this.onSelectionChange,
      openPipeline: openPipeline,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 308,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_confirm_delete_modal.ConfirmDeleteModal, {
      cancelDeletePipelines: this.cancelDeletePipelines,
      deleteSelectedPipelines: this.deleteSelectedPipelines,
      selection: selection,
      showConfirmDeleteModal: showConfirmDeleteModal,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_info_alerts.InfoAlerts, {
      showAddRoleAlert: !isServerless && this.state.showAddRoleAlert,
      showEnableMonitoringAlert: !isServerless && this.state.showEnableMonitoringAlert,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 327,
        columnNumber: 9
      }
    }));
  }
}
const PipelineList = exports.PipelineList = (0, _i18nReact.injectI18n)(PipelineListUi);