"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.truncate = exports.count = void 0;
var _gptTokenizer = require("gpt-tokenizer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const count = text => {
  return (0, _gptTokenizer.encode)(text).length;
};
exports.count = count;
const truncate = (text, maxTokens) => {
  const encoded = (0, _gptTokenizer.encode)(text);
  if (encoded.length > maxTokens) {
    const truncated = encoded.slice(0, maxTokens);
    return (0, _gptTokenizer.decode)(truncated);
  }
  return text;
};
exports.truncate = truncate;