"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WILDCARD_WITH_IS_OPERATOR_TOOLTIP = exports.VALUE = exports.OR = exports.OPERATOR = exports.FIELD_CONFLICT_INDICES_WARNING_DESCRIPTION = exports.FIELD = exports.EXCEPTION_OPERATOR_PLACEHOLDER = exports.EXCEPTION_ITEM_ARIA_LABEL = exports.EXCEPTION_FIELD_VALUE_PLACEHOLDER = exports.EXCEPTION_FIELD_PLACEHOLDER = exports.EXCEPTION_FIELD_NESTED_PLACEHOLDER = exports.EXCEPTION_FIELD_LISTS_PLACEHOLDER = exports.CUSTOM_COMBOBOX_OPTION_TEXT = exports.CONFLICT_MULTIPLE_INDEX_DESCRIPTION = exports.AND = exports.ADD_NON_NESTED_DESCRIPTION = exports.ADD_NESTED_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELD = exports.FIELD = _i18n.i18n.translate('xpack.lists.exceptions.builder.fieldLabel', {
  defaultMessage: 'Field'
});
const OPERATOR = exports.OPERATOR = _i18n.i18n.translate('xpack.lists.exceptions.builder.operatorLabel', {
  defaultMessage: 'Operator'
});
const VALUE = exports.VALUE = _i18n.i18n.translate('xpack.lists.exceptions.builder.valueLabel', {
  defaultMessage: 'Value'
});
const EXCEPTION_ITEM_ARIA_LABEL = (name, groupIndex, positionIndex) => _i18n.i18n.translate('xpack.lists.exceptions.item.ariaLabel', {
  defaultMessage: '"{name}" in group {group}, position {position} ',
  values: {
    group: groupIndex + 1,
    name,
    position: positionIndex + 1
  }
});
exports.EXCEPTION_ITEM_ARIA_LABEL = EXCEPTION_ITEM_ARIA_LABEL;
const EXCEPTION_FIELD_VALUE_PLACEHOLDER = exports.EXCEPTION_FIELD_VALUE_PLACEHOLDER = _i18n.i18n.translate('xpack.lists.exceptions.builder.exceptionFieldValuePlaceholder', {
  defaultMessage: 'Search field value...'
});
const EXCEPTION_FIELD_NESTED_PLACEHOLDER = exports.EXCEPTION_FIELD_NESTED_PLACEHOLDER = _i18n.i18n.translate('xpack.lists.exceptions.builder.exceptionFieldNestedPlaceholder', {
  defaultMessage: 'Search nested field'
});
const EXCEPTION_FIELD_LISTS_PLACEHOLDER = exports.EXCEPTION_FIELD_LISTS_PLACEHOLDER = _i18n.i18n.translate('xpack.lists.exceptions.builder.exceptionListsPlaceholder', {
  defaultMessage: 'Search for list...'
});
const EXCEPTION_FIELD_PLACEHOLDER = exports.EXCEPTION_FIELD_PLACEHOLDER = _i18n.i18n.translate('xpack.lists.exceptions.builder.exceptionFieldPlaceholder', {
  defaultMessage: 'Search'
});
const EXCEPTION_OPERATOR_PLACEHOLDER = exports.EXCEPTION_OPERATOR_PLACEHOLDER = _i18n.i18n.translate('xpack.lists.exceptions.builder.exceptionOperatorPlaceholder', {
  defaultMessage: 'Operator'
});
const ADD_NESTED_DESCRIPTION = exports.ADD_NESTED_DESCRIPTION = _i18n.i18n.translate('xpack.lists.exceptions.builder.addNestedDescription', {
  defaultMessage: 'Add nested condition'
});
const ADD_NON_NESTED_DESCRIPTION = exports.ADD_NON_NESTED_DESCRIPTION = _i18n.i18n.translate('xpack.lists.exceptions.builder.addNonNestedDescription', {
  defaultMessage: 'Add non-nested condition'
});
const AND = exports.AND = _i18n.i18n.translate('xpack.lists.exceptions.andDescription', {
  defaultMessage: 'AND'
});
const OR = exports.OR = _i18n.i18n.translate('xpack.lists.exceptions.orDescription', {
  defaultMessage: 'OR'
});
const CUSTOM_COMBOBOX_OPTION_TEXT = exports.CUSTOM_COMBOBOX_OPTION_TEXT = _i18n.i18n.translate('xpack.lists.exceptions.comboBoxCustomOptionText', {
  defaultMessage: 'Select a field from the list. If your field is not available, create a custom one.'
});
const FIELD_CONFLICT_INDICES_WARNING_DESCRIPTION = exports.FIELD_CONFLICT_INDICES_WARNING_DESCRIPTION = _i18n.i18n.translate('xpack.lists.exceptions.field.mappingConflict.description', {
  defaultMessage: 'This field is defined as different types across the following indices or is unmapped. This can cause unexpected query results.'
});
const CONFLICT_MULTIPLE_INDEX_DESCRIPTION = (name, count) => _i18n.i18n.translate('xpack.lists.exceptions.field.index.description', {
  defaultMessage: '{name} ({count} indices)',
  values: {
    count,
    name
  }
});
exports.CONFLICT_MULTIPLE_INDEX_DESCRIPTION = CONFLICT_MULTIPLE_INDEX_DESCRIPTION;
const WILDCARD_WITH_IS_OPERATOR_TOOLTIP = exports.WILDCARD_WITH_IS_OPERATOR_TOOLTIP = _i18n.i18n.translate('xpack.lists.exceptions.builder.exceptionIsOperator.warningmessage.tooltip', {
  defaultMessage: 'Using a wildcard with the "IS" operator can make an entry ineffective. Change the operator to "MATCHES" to ensure wildcards run properly.'
});