"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadLicense = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _telemetry_opt_in = require("../../components/telemetry_opt_in");
var _telemetry = require("../../lib/telemetry");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/license_management/public/application/sections/upload_license/upload_license.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class UploadLicense extends _react.default.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isOptingInToTelemetry: false
    });
    (0, _defineProperty2.default)(this, "onOptInChange", isOptingInToTelemetry => {
      this.setState({
        isOptingInToTelemetry
      });
    });
    (0, _defineProperty2.default)(this, "send", acknowledge => {
      const file = this.file;
      const fr = new FileReader();
      fr.onload = ({
        target: {
          result
        }
      }) => {
        if (this.state.isOptingInToTelemetry) {
          var _this$props$telemetry;
          (_this$props$telemetry = this.props.telemetry) === null || _this$props$telemetry === void 0 ? void 0 : _this$props$telemetry.telemetryService.setOptIn(true);
        }
        this.props.uploadLicense(result, this.props.currentLicenseType, acknowledge);
      };
      fr.readAsText(file);
    });
    (0, _defineProperty2.default)(this, "cancel", () => {
      this.props.uploadLicenseStatus({});
    });
    (0, _defineProperty2.default)(this, "handleFile", ([file]) => {
      if (file) {
        this.props.addUploadErrorMessage('');
      }
      this.file = file;
    });
    (0, _defineProperty2.default)(this, "submit", event => {
      event.preventDefault();
      if (this.file) {
        this.send();
      } else {
        this.props.addUploadErrorMessage(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.uploadLicense.licenseFileNotSelectedErrorMessage",
          defaultMessage: "You must select a license file.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 122,
            columnNumber: 9
          }
        }));
      }
    });
  }
  componentDidMount() {
    this.props.setBreadcrumb('upload');
    this.props.addUploadErrorMessage('');
  }
  acknowledgeModal() {
    const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
    const {
      needsAcknowledgement,
      messages: [firstLine, ...messages] = []
    } = this.props;
    if (!needsAcknowledgement) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      titleProps: {
        id: confirmModalTitleId
      },
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.uploadLicense.confirmModalTitle",
        defaultMessage: "Confirm License Upload",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 11
        }
      }),
      onCancel: this.cancel,
      onConfirm: () => this.send(true),
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.uploadLicense.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 11
        }
      }),
      confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.uploadLicense.confirmModal.confirmButtonLabel",
        defaultMessage: "Confirm",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 11
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }, firstLine), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }, messages.map(message => /*#__PURE__*/_react.default.createElement("li", {
      key: message,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 17
      }
    }, message))))));
  }
  errorMessage() {
    const {
      errorMessage
    } = this.props;
    if (!errorMessage) {
      return null;
    }
    return [errorMessage];
  }
  render() {
    const {
      currentLicenseType,
      applying,
      telemetry,
      history
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      paddingSize: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.uploadLicense.uploadLicenseTitle",
      defaultMessage: "Upload your license",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 11
      }
    }), this.acknowledgeModal(), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.uploadLicense.licenseKeyTypeDescription",
      defaultMessage: "Your license key is a JSON file with a signature attached.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.uploadLicense.replacingCurrentLicenseWarningMessage",
      defaultMessage: "Uploading a license will replace your current {currentLicenseType} license.",
      values: {
        currentLicenseType: /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 160,
            columnNumber: 39
          }
        }, currentLicenseType.toUpperCase())
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      isInvalid: !!this.errorMessage(),
      error: this.errorMessage(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
      fullWidth: true,
      id: "licenseFile",
      initialPromptText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.uploadLicense.selectLicenseFileDescription",
        defaultMessage: "Select or drag your license file",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 17
        }
      }),
      onChange: this.handleFile,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 13
      }
    }), (0, _telemetry.shouldShowTelemetryOptIn)(telemetry) && /*#__PURE__*/_react.default.createElement(_telemetry_opt_in.TelemetryOptIn, {
      isOptingInToTelemetry: this.state.isOptingInToTelemetry,
      onOptInChange: this.onOptInChange,
      telemetry: telemetry,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
      "data-test-subj": "cancelUploadButton"
    }, (0, _public.reactRouterNavigate)(history, '/home'), {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.uploadLicense.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "uploadLicenseButton",
      fill: true,
      isLoading: applying,
      onClick: this.submit,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 17
      }
    }, applying ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.uploadLicense.uploadingButtonLabel",
      defaultMessage: "Uploading\u2026",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 21
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.uploadLicense.uploadButtonLabel",
      defaultMessage: "Upload",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 21
      }
    })))))));
  }
}
exports.UploadLicense = UploadLicense;