"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensGetResponseBodySchema = exports.lensGetRequestParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _content_management = require("../../../../content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lensGetRequestParamsSchema = exports.lensGetRequestParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    meta: {
      description: 'The saved object id of a Lens visualization.'
    }
  })
}, {
  unknowns: 'forbid'
});
const lensGetResponseBodySchema = exports.lensGetResponseBodySchema = _configSchema.schema.object({
  data: _content_management.lensResponseItemSchema.getPropSchemas().data,
  meta: _configSchema.schema.object({
    ..._content_management.lensCMGetResultSchema.getPropSchemas().meta.getPropSchemas(),
    // include CM meta data
    ..._content_management.lensResponseItemSchema.getPropSchemas().meta.getPropSchemas()
  }, {
    unknowns: 'forbid'
  })
}, {
  unknowns: 'forbid'
});