"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stackingTypes = exports.getXyVisualization = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _chartIcons = require("@kbn/chart-icons");
var _eventAnnotationComponents = require("@kbn/event-annotation-components");
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/expression-xy-plugin/public");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _coloring = require("@kbn/coloring");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _palettes = require("@kbn/palettes");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _id_generator = require("../../id_generator");
var _utils = require("../../utils");
var _xy_suggestions = require("./xy_suggestions");
var _xy_config_panel = require("./xy_config_panel");
var _dimension_editor = require("./xy_config_panel/dimension_editor");
var _layer_header = require("./xy_config_panel/layer_header");
var _types = require("./types");
var _state_helpers = require("./state_helpers");
var _to_expression = require("./to_expression");
var _color_assignment = require("./color_assignment");
var _reference_line_helpers = require("./reference_line_helpers");
var _helpers = require("./annotations/helpers");
var _visualization_helpers = require("./visualization_helpers");
var _axes_configuration = require("./axes_configuration");
var _drop_targets_utils = require("../../editor_frame_service/editor_frame/config_panel/buttons/drop_targets_utils");
var _actions = require("./annotations/actions");
var _add_layer = require("./add_layer");
var _layer_settings = require("./layer_settings");
var _ignore_global_filter = require("../../shared_components/ignore_global_filter");
var _color_telemetry_helpers = require("../../lens_ui_telemetry/color_telemetry_helpers");
var _legend_stats_telemetry_helpers = require("./legend_stats_telemetry_helpers");
var _persistence = require("./persistence");
var _legend_settings_popover = require("../../shared_components/legend/legend_settings_popover");
var _user_messages_ids = require("../../user_messages_ids");
var _annotations_panel = require("./xy_config_panel/annotations_config_panel/annotations_panel");
var _reference_line_panel = require("./xy_config_panel/reference_line_config_panel/reference_line_panel");
var _runtime_state = require("./runtime_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/visualization.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const XY_ID = 'lnsXY';
const getXyVisualization = ({
  core,
  storage,
  data,
  paletteService,
  fieldFormats,
  kibanaTheme,
  eventAnnotationService,
  unifiedSearch,
  dataViewsService,
  savedObjectsTagging
}) => ({
  id: XY_ID,
  getVisualizationTypeId(state, layerId) {
    const type = (0, _visualization_helpers.getVisualizationType)(state, layerId);
    return type === 'mixed' ? type : type.id;
  },
  visualizationTypes: _types.visualizationTypes,
  getLayerIds(state) {
    return (0, _visualization_helpers.getLayersByType)(state).map(l => l.layerId);
  },
  getRemoveOperation(state, layerId) {
    const dataLayers = (0, _visualization_helpers.getLayersByType)(state, _public2.LayerTypes.DATA).map(l => l.layerId);
    return dataLayers.includes(layerId) && dataLayers.length === 1 ? 'clear' : 'remove';
  },
  removeLayer(state, layerId) {
    return {
      ...state,
      layers: state.layers.filter(l => l.layerId !== layerId)
    };
  },
  cloneLayer(state, layerId, newLayerId, clonedIDsMap) {
    const toCopyLayer = state.layers.find(l => l.layerId === layerId);
    if (toCopyLayer) {
      if ((0, _visualization_helpers.isAnnotationsLayer)(toCopyLayer)) {
        toCopyLayer.annotations.forEach(i => clonedIDsMap.set(i.id, (0, _id_generator.generateId)()));
      }
      let newLayer = (0, _utils.renewIDs)(toCopyLayer, [...clonedIDsMap.keys()], id => clonedIDsMap.get(id));
      newLayer.layerId = newLayerId;
      if ((0, _visualization_helpers.isAnnotationsLayer)(newLayer) && (0, _visualization_helpers.isByReferenceAnnotationsLayer)(newLayer)) {
        const byValueVersion = {
          annotations: newLayer.annotations,
          ignoreGlobalFilters: newLayer.ignoreGlobalFilters,
          layerId: newLayer.layerId,
          layerType: newLayer.layerType,
          indexPatternId: newLayer.indexPatternId
        };
        newLayer = byValueVersion;
      }
      return {
        ...state,
        layers: [...state.layers, newLayer]
      };
    }
    return state;
  },
  appendLayer(state, layerId, layerType, indexPatternId, extraArg, seriesType) {
    var _getDataLayers, _getDataLayers$;
    if (layerType === 'metricTrendline') {
      return state;
    }
    return {
      ...state,
      layers: [...state.layers, (0, _visualization_helpers.newLayerState)({
        layerId,
        layerType,
        seriesType: seriesType || ((_getDataLayers = (0, _visualization_helpers.getDataLayers)(state.layers)) === null || _getDataLayers === void 0 ? void 0 : (_getDataLayers$ = _getDataLayers[0]) === null || _getDataLayers$ === void 0 ? void 0 : _getDataLayers$.seriesType) || state.preferredSeriesType,
        indexPatternId,
        extraArg
      })]
    };
  },
  clearLayer(state, layerId, indexPatternId) {
    return {
      ...state,
      layers: state.layers.map(l => l.layerId !== layerId ? l : (0, _visualization_helpers.newLayerState)({
        seriesType: state.preferredSeriesType,
        layerId,
        indexPatternId
      }))
    };
  },
  getPersistableState(state) {
    return (0, _persistence.convertToPersistable)(state);
  },
  getDescription: _visualization_helpers.getDescription,
  switchVisualizationType(seriesType, state, layerId) {
    const dataLayer = layerId ? state.layers.find(l => l.layerId === layerId) : state.layers.at(0);
    if (dataLayer && !(0, _visualization_helpers.isDataLayer)(dataLayer)) {
      throw new Error('Cannot switch series type for non-data layer');
    }
    if (!dataLayer) {
      return state;
    }
    const currentStackingType = stackingTypes.find(({
      subtypes
    }) => subtypes.includes(dataLayer.seriesType));
    const chosenTypeIndex = defaultSeriesTypesByIndex.indexOf(seriesType);
    const compatibleSeriesType = (currentStackingType === null || currentStackingType === void 0 ? void 0 : currentStackingType.subtypes[chosenTypeIndex]) || seriesType;
    return {
      ...state,
      preferredSeriesType: compatibleSeriesType,
      layers: layerId ? state.layers.map(layer => layer.layerId === layerId ? {
        ...layer,
        seriesType: compatibleSeriesType
      } : layer) : state.layers.map(layer => ({
        ...layer,
        seriesType: compatibleSeriesType
      }))
    };
  },
  getSuggestions: _xy_suggestions.getSuggestions,
  triggers: [_public.VIS_EVENT_TO_TRIGGER.filter, _public.VIS_EVENT_TO_TRIGGER.brush],
  initialize(addNewLayer, persistedState, mainPalette, datasourceStates, annotationGroups, references) {
    if (persistedState) {
      const convertedState = (0, _persistence.convertPersistedState)(persistedState, annotationGroups, references);
      return (0, _runtime_state.convertToRuntimeState)(convertedState, datasourceStates);
    }
    return {
      title: 'Empty XY chart',
      legend: {
        isVisible: true,
        position: _charts.Position.Right
      },
      valueLabels: 'hide',
      preferredSeriesType: _types.defaultSeriesType,
      layers: [{
        layerId: addNewLayer(),
        accessors: [],
        position: _charts.Position.Top,
        seriesType: _types.defaultSeriesType,
        showGridlines: false,
        layerType: _public2.LayerTypes.DATA,
        palette: (mainPalette === null || mainPalette === void 0 ? void 0 : mainPalette.type) === 'legacyPalette' ? mainPalette.value : undefined,
        colorMapping: (mainPalette === null || mainPalette === void 0 ? void 0 : mainPalette.type) === 'colorMapping' ? mainPalette.value : (0, _utils.getColorMappingDefaults)()
      }]
    };
  },
  convertToRuntimeState(state, datasourceStates) {
    return (0, _runtime_state.convertToRuntimeState)(state, datasourceStates);
  },
  getLayerType(layerId, state) {
    var _state$layers$find;
    return state === null || state === void 0 ? void 0 : (_state$layers$find = state.layers.find(({
      layerId: id
    }) => id === layerId)) === null || _state$layers$find === void 0 ? void 0 : _state$layers$find.layerType;
  },
  getSupportedLayers(state, frame) {
    return [_visualization_helpers.supportedDataLayer, (0, _helpers.getAnnotationsSupportedLayer)(state, frame), (0, _reference_line_helpers.getReferenceSupportedLayer)(state, frame)];
  },
  getSupportedActionsForLayer(layerId, state, setState, registerLibraryAnnotationGroup, isSaveable) {
    const layerIndex = state.layers.findIndex(l => l.layerId === layerId);
    const layer = state.layers[layerIndex];
    const actions = [];
    if ((0, _visualization_helpers.isAnnotationsLayer)(layer)) {
      actions.push(...(0, _actions.createAnnotationActions)({
        state,
        layer,
        setState,
        registerLibraryAnnotationGroup,
        core,
        isSaveable,
        eventAnnotationService,
        savedObjectsTagging,
        dataViews: data.dataViews,
        startServices: core
      }));
    }
    return actions;
  },
  getCustomRemoveLayerText(layerId, state) {
    const layerIndex = state.layers.findIndex(l => l.layerId === layerId);
    const layer = state.layers[layerIndex];
    if (layer && (0, _visualization_helpers.isByReferenceAnnotationsLayer)(layer)) {
      return {
        title: `Delete "${(0, _visualization_helpers.getAnnotationLayerTitle)(layer)}"`
      };
    }
  },
  hasLayerSettings({
    state,
    layerId: currentLayerId
  }) {
    var _state$layers;
    const layer = (_state$layers = state.layers) === null || _state$layers === void 0 ? void 0 : _state$layers.find(({
      layerId
    }) => layerId === currentLayerId);
    return {
      data: Boolean(layer && (0, _visualization_helpers.isAnnotationsLayer)(layer)),
      appearance: false
    };
  },
  LayerSettingsComponent(props) {
    return /*#__PURE__*/_react.default.createElement(_layer_settings.LayerSettings, (0, _extends2.default)({}, props, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 396,
        columnNumber: 12
      }
    }));
  },
  onIndexPatternChange(state, indexPatternId, layerId) {
    const layerIndex = state.layers.findIndex(l => l.layerId === layerId);
    const layer = state.layers[layerIndex];
    if (!layer || !(0, _visualization_helpers.isAnnotationsLayer)(layer)) {
      return state;
    }
    const newLayers = [...state.layers];
    newLayers[layerIndex] = {
      ...layer,
      indexPatternId
    };
    return {
      ...state,
      layers: newLayers
    };
  },
  getConfiguration({
    state,
    frame,
    layerId
  }) {
    const layer = state.layers.find(l => l.layerId === layerId);
    if (!layer) {
      return {
        groups: []
      };
    }
    if ((0, _visualization_helpers.isAnnotationsLayer)(layer)) {
      return (0, _helpers.getAnnotationsConfiguration)({
        state,
        frame,
        layer
      });
    }
    const sortedAccessors = (0, _to_expression.getSortedAccessors)(frame.datasourceLayers[layer.layerId], layer);
    if ((0, _visualization_helpers.isReferenceLayer)(layer)) {
      return (0, _reference_line_helpers.getReferenceConfiguration)({
        state,
        frame,
        layer,
        sortedAccessors
      });
    }
    const mappedAccessors = getMappedAccessors({
      state,
      frame,
      layer,
      fieldFormats,
      paletteService,
      accessors: sortedAccessors
    });
    const dataLayer = layer;
    const dataLayers = (0, _visualization_helpers.getDataLayers)(state.layers);
    const isHorizontal = (0, _state_helpers.isHorizontalChart)(state.layers);
    const {
      left,
      right
    } = (0, _axes_configuration.groupAxesByType)([layer], frame.activeData);
    // Check locally if it has one accessor OR one accessor per axis
    const layerHasOnlyOneAccessor = Boolean(dataLayer.accessors.length < 2 || left.length && left.length < 2 || right.length && right.length < 2);
    // Check also for multiple layers that can stack for percentage charts
    // Make sure that if multiple dimensions are defined for a single dataLayer, they should belong to the same axis
    const hasOnlyOneAccessor = layerHasOnlyOneAccessor && dataLayers.filter(
    // check that the other layers are compatible with this one
    l => {
      if ((0, _visualization_helpers.isDataLayer)(l) && l.seriesType === dataLayer.seriesType && Boolean(l.xAccessor) === Boolean(dataLayer.xAccessor) && Boolean(l.splitAccessor) === Boolean(dataLayer.splitAccessor)) {
        const {
          left: localLeft,
          right: localRight
        } = (0, _axes_configuration.groupAxesByType)([l], frame.activeData);
        // return true only if matching axis are found
        return l.accessors.length && (Boolean(localLeft.length) === Boolean(left.length) || Boolean(localRight.length) === Boolean(right.length));
      }
      return false;
    }).length < 2;
    const canUseColorMapping = layer.colorMapping ? true : false;
    let colors = [];
    if (canUseColorMapping) {
      kibanaTheme.theme$.subscribe({
        next(theme) {
          const palettes = (0, _palettes.getKbnPalettes)(theme);
          colors = (0, _coloring.getColorsFromMapping)(palettes, theme.darkMode, layer.colorMapping);
        }
      }).unsubscribe();
    } else {
      var _dataLayer$palette, _dataLayer$palette2;
      const palette = paletteService.get(((_dataLayer$palette = dataLayer.palette) === null || _dataLayer$palette === void 0 ? void 0 : _dataLayer$palette.name) || 'default');
      colors = palette.getCategoricalColors(10, (_dataLayer$palette2 = dataLayer.palette) === null || _dataLayer$palette2 === void 0 ? void 0 : _dataLayer$palette2.params);
    }
    return {
      groups: [{
        groupId: 'x',
        groupLabel: (0, _visualization_helpers.getAxisName)('x', {
          isHorizontal
        }),
        accessors: dataLayer.xAccessor ? [{
          columnId: dataLayer.xAccessor
        }] : [],
        filterOperations: _visualization_helpers.isBucketed,
        supportsMoreColumns: !dataLayer.xAccessor,
        dataTestSubj: 'lnsXY_xDimensionPanel'
      }, {
        groupId: 'y',
        groupLabel: (0, _visualization_helpers.getAxisName)('y', {
          isHorizontal
        }),
        accessors: mappedAccessors,
        filterOperations: _visualization_helpers.isNumericDynamicMetric,
        isMetricDimension: true,
        supportsMoreColumns: true,
        requiredMinDimensionCount: 1,
        dataTestSubj: 'lnsXY_yDimensionPanel',
        enableDimensionEditor: true
      }, {
        groupId: 'breakdown',
        groupLabel: _i18n.i18n.translate('xpack.lens.xyChart.splitSeries', {
          defaultMessage: 'Breakdown'
        }),
        accessors: dataLayer.splitAccessor ? [{
          columnId: dataLayer.splitAccessor,
          triggerIconType: dataLayer.collapseFn ? 'aggregate' : 'colorBy',
          palette: dataLayer.collapseFn ? undefined : colors
        }] : [],
        filterOperations: _visualization_helpers.isBucketed,
        supportsMoreColumns: !dataLayer.splitAccessor,
        dataTestSubj: 'lnsXY_splitDimensionPanel',
        requiredMinDimensionCount: dataLayer.seriesType.includes('percentage') && hasOnlyOneAccessor ? 1 : 0,
        enableDimensionEditor: true,
        isBreakdownDimension: true
      }]
    };
  },
  getMainPalette: state => {
    if (!state || state.layers.length === 0) return;
    const firstDataLayer = (0, _visualization_helpers.getFirstDataLayer)(state.layers);
    return firstDataLayer !== null && firstDataLayer !== void 0 && firstDataLayer.colorMapping ? {
      type: 'colorMapping',
      value: firstDataLayer.colorMapping
    } : firstDataLayer !== null && firstDataLayer !== void 0 && firstDataLayer.palette ? {
      type: 'legacyPalette',
      value: firstDataLayer.palette
    } : undefined;
  },
  getDropProps(dropProps) {
    if (!dropProps.source) {
      return;
    }
    const srcDataView = dropProps.source.indexPatternId;
    const targetDataView = dropProps.target.indexPatternId;
    if (!targetDataView || srcDataView !== targetDataView) {
      return;
    }
    if ((0, _utils.isDraggedDataViewField)(dropProps.source)) {
      if (dropProps.source.field.type === 'document') {
        return;
      }
      return dropProps.target.isNewColumn ? {
        dropTypes: ['field_add']
      } : {
        dropTypes: ['field_replace']
      };
    }
    if ((0, _utils.isOperationFromTheSameGroup)(dropProps.source, dropProps.target)) {
      return dropProps.target.isNewColumn ? {
        dropTypes: ['duplicate_compatible']
      } : {
        dropTypes: ['reorder']
      };
    }
    if ((0, _utils.isOperationFromCompatibleGroup)(dropProps.source, dropProps.target)) {
      return {
        dropTypes: dropProps.target.isNewColumn ? ['move_compatible', 'duplicate_compatible'] : ['replace_compatible', 'replace_duplicate_compatible', 'swap_compatible']
      };
    }
  },
  onDrop(props) {
    const targetLayer = props.prevState.layers.find(l => l.layerId === props.target.layerId);
    if (!targetLayer) {
      throw new Error('target layer should exist');
    }
    if ((0, _visualization_helpers.isAnnotationsLayer)(targetLayer)) {
      return (_helpers.onAnnotationDrop === null || _helpers.onAnnotationDrop === void 0 ? void 0 : (0, _helpers.onAnnotationDrop)(props)) || props.prevState;
    }
    return (0, _drop_targets_utils.onDropForVisualization)(props, this);
  },
  setDimension(props) {
    const {
      prevState,
      layerId,
      columnId,
      groupId
    } = props;
    const foundLayer = prevState.layers.find(l => l.layerId === layerId);
    if (!foundLayer) {
      return prevState;
    }
    if ((0, _visualization_helpers.isReferenceLayer)(foundLayer)) {
      return (0, _reference_line_helpers.setReferenceDimension)(props);
    }
    if ((0, _visualization_helpers.isAnnotationsLayer)(foundLayer)) {
      return (0, _helpers.setAnnotationsDimension)(props);
    }
    const newLayer = Object.assign({}, foundLayer);
    if (groupId === 'x') {
      newLayer.xAccessor = columnId;
    }
    if (groupId === 'y') {
      newLayer.accessors = [...newLayer.accessors.filter(a => a !== columnId), columnId];
    }
    if (groupId === 'breakdown') {
      newLayer.splitAccessor = columnId;
    }
    return {
      ...prevState,
      layers: prevState.layers.map(l => l.layerId === layerId ? newLayer : l)
    };
  },
  removeDimension({
    prevState,
    layerId,
    columnId,
    frame
  }) {
    const foundLayer = prevState.layers.find(l => l.layerId === layerId);
    if (!foundLayer) {
      return prevState;
    }
    if ((0, _visualization_helpers.isAnnotationsLayer)(foundLayer)) {
      const newLayer = {
        ...foundLayer,
        annotations: foundLayer.annotations.filter(({
          id
        }) => id !== columnId)
      };
      const newLayers = prevState.layers.map(l => l.layerId === layerId ? newLayer : l);
      return {
        ...prevState,
        layers: newLayers
      };
    }
    const newLayer = {
      ...foundLayer
    };
    if ((0, _visualization_helpers.isDataLayer)(newLayer)) {
      if (newLayer.xAccessor === columnId) {
        delete newLayer.xAccessor;
      } else if (newLayer.splitAccessor === columnId) {
        delete newLayer.splitAccessor;
        // as the palette is associated with the break down by dimension, remove it together with the dimension
        delete newLayer.palette;
      }
    }
    if (newLayer.accessors.includes(columnId)) {
      newLayer.accessors = newLayer.accessors.filter(a => a !== columnId);
    }
    if ('yConfig' in newLayer) {
      var _newLayer$yConfig;
      newLayer.yConfig = (_newLayer$yConfig = newLayer.yConfig) === null || _newLayer$yConfig === void 0 ? void 0 : _newLayer$yConfig.filter(({
        forAccessor
      }) => forAccessor !== columnId);
    }
    let newLayers = prevState.layers.map(l => l.layerId === layerId ? newLayer : l);
    // check if there's any reference layer and pull it off if all data layers have no dimensions set
    // check for data layers if they all still have xAccessors
    const groupsAvailable = (0, _reference_line_helpers.getGroupsAvailableInData)((0, _visualization_helpers.getDataLayers)(prevState.layers), frame.datasourceLayers, frame.activeData);
    if (Object.keys(groupsAvailable).every(id => !groupsAvailable[id])) {
      newLayers = newLayers.filter(layer => (0, _visualization_helpers.isDataLayer)(layer) || 'accessors' in layer && layer.accessors.length);
    }
    return {
      ...prevState,
      layers: newLayers
    };
  },
  LayerPanelComponent(props) {
    const {
      onChangeIndexPattern,
      ...otherProps
    } = props;
    return /*#__PURE__*/_react.default.createElement(_layer_header.LayerHeaderContent, (0, _extends2.default)({}, otherProps, {
      onChangeIndexPattern: indexPatternId => {
        onChangeIndexPattern(indexPatternId);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 693,
        columnNumber: 7
      }
    }));
  },
  isSubtypeCompatible(subtype1, subtype2) {
    return (0, _state_helpers.isHorizontalSeries)(subtype1) && (0, _state_helpers.isHorizontalSeries)(subtype2) || !(0, _state_helpers.isHorizontalSeries)(subtype1) && !(0, _state_helpers.isHorizontalSeries)(subtype2);
  },
  getSubtypeSwitch({
    state,
    setState,
    layerId
  }) {
    const index = state.layers.findIndex(l => l.layerId === layerId);
    const layer = state.layers[index];
    if (!layer || !(0, _visualization_helpers.isDataLayer)(layer) || layer.seriesType === 'line') {
      return null;
    }
    return () => /*#__PURE__*/_react.default.createElement(SubtypeSwitch, {
      layer: layer,
      setLayerState: newLayer => setState((0, _xy_config_panel.updateLayer)(state, newLayer, index)),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 717,
        columnNumber: 7
      }
    });
  },
  getCustomLayerHeader(props) {
    const layer = props.state.layers.find(l => l.layerId === props.layerId);
    if (!layer) {
      return undefined;
    }
    if ((0, _visualization_helpers.isReferenceLayer)(layer)) {
      return /*#__PURE__*/_react.default.createElement(_layer_header.ReferenceLayerHeader, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 732,
          columnNumber: 14
        }
      });
    }
    if ((0, _visualization_helpers.isAnnotationsLayer)(layer)) {
      return /*#__PURE__*/_react.default.createElement(_layer_header.AnnotationsLayerHeader, {
        title: (0, _visualization_helpers.getAnnotationLayerTitle)(layer),
        hasUnsavedChanges: (0, _state_helpers.annotationLayerHasUnsavedChanges)(layer),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 736,
          columnNumber: 9
        }
      });
    }
    return undefined;
  },
  ToolbarComponent(props) {
    return /*#__PURE__*/_react.default.createElement(_xy_config_panel.XyToolbar, (0, _extends2.default)({}, props, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 746,
        columnNumber: 12
      }
    }));
  },
  DimensionEditorComponent(props) {
    const allProps = {
      ...props,
      datatableUtilities: data.datatableUtilities,
      formatFactory: fieldFormats.deserialize,
      paletteService
    };
    const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
    const palettes = (0, _palettes.useKbnPalettes)();
    const layer = props.state.layers.find(l => l.layerId === props.layerId);
    const dimensionEditor = (0, _visualization_helpers.isReferenceLayer)(layer) ? /*#__PURE__*/_react.default.createElement(_reference_line_panel.ReferenceLinePanel, (0, _extends2.default)({}, allProps, {
      palettes: palettes,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 762,
        columnNumber: 7
      }
    })) : (0, _visualization_helpers.isAnnotationsLayer)(layer) ? /*#__PURE__*/_react.default.createElement(_annotations_panel.AnnotationsPanel, (0, _extends2.default)({}, allProps, {
      dataViewsService: dataViewsService,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 764,
        columnNumber: 7
      }
    })) : /*#__PURE__*/_react.default.createElement(_dimension_editor.DataDimensionEditor, (0, _extends2.default)({}, allProps, {
      palettes: palettes,
      isDarkMode: isDarkMode,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 766,
        columnNumber: 7
      }
    }));
    return dimensionEditor;
  },
  DimensionEditorDataExtraComponent(props) {
    const allProps = {
      ...props,
      datatableUtilities: data.datatableUtilities,
      formatFactory: fieldFormats.deserialize,
      paletteService
    };
    const layer = props.state.layers.find(l => l.layerId === props.layerId);
    if ((0, _visualization_helpers.isReferenceLayer)(layer)) {
      return null;
    }
    if ((0, _visualization_helpers.isAnnotationsLayer)(layer)) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_dimension_editor.DataDimensionEditorDataSectionExtra, (0, _extends2.default)({}, allProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 787,
        columnNumber: 12
      }
    }));
  },
  getAddLayerButtonComponent: props => {
    return /*#__PURE__*/_react.default.createElement(_add_layer.AddLayerButton, (0, _extends2.default)({}, props, {
      eventAnnotationService: eventAnnotationService,
      addLayer: async (type, loadedGroupInfo, _, seriesType) => {
        if (type === _public2.LayerTypes.ANNOTATIONS && loadedGroupInfo) {
          var _loadedGroupInfo$data;
          await props.ensureIndexPattern((_loadedGroupInfo$data = loadedGroupInfo.dataViewSpec) !== null && _loadedGroupInfo$data !== void 0 ? _loadedGroupInfo$data : loadedGroupInfo.indexPatternId);
          props.registerLibraryAnnotationGroup({
            id: loadedGroupInfo.annotationGroupId,
            group: loadedGroupInfo
          });
        }
        props.addLayer(type, loadedGroupInfo, !!loadedGroupInfo, seriesType);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 791,
        columnNumber: 7
      }
    }));
  },
  toExpression: (state, layers, _attributes, datasourceExpressionsByLayers = {}) => (0, _to_expression.toExpression)(state, layers, paletteService, datasourceExpressionsByLayers, eventAnnotationService),
  toPreviewExpression: (state, layers, datasourceExpressionsByLayers = {}) => (0, _to_expression.toPreviewExpression)(state, layers, paletteService, datasourceExpressionsByLayers, eventAnnotationService),
  getUserMessages(state, {
    frame
  }) {
    const {
      datasourceLayers,
      dataViews,
      activeData
    } = frame;
    const annotationLayers = (0, _visualization_helpers.getAnnotationsLayers)(state.layers);
    const errors = [];
    const hasDateHistogram = (0, _visualization_helpers.isTimeChart)((0, _visualization_helpers.getDataLayers)(state.layers), frame);
    annotationLayers.forEach(layer => {
      layer.annotations.forEach(annotation => {
        if (!hasDateHistogram) {
          errors.push({
            uniqueId: _user_messages_ids.ANNOTATION_MISSING_DATE_HISTOGRAM,
            severity: 'error',
            fixableInEditor: true,
            displayLocations: [{
              id: 'dimensionButton',
              dimensionId: annotation.id
            }],
            shortMessage: _i18n.i18n.translate('xpack.lens.xyChart.addAnnotationsLayerLabelDisabledHelp', {
              defaultMessage: 'Annotations require a time based chart to work. Add a date histogram.'
            }),
            longMessage: ''
          });
        }
        const errorMessages = (0, _state_helpers.getAnnotationLayerErrors)(layer, annotation.id, dataViews);
        errors.push(...errorMessages);
      });
    });

    // check if the layers in the state are compatible with this type of chart
    if (state && state.layers.length > 1) {
      // Order is important here: Y Axis is fundamental to exist to make it valid
      const yLayerValidation = (0, _visualization_helpers.validateLayersForDimension)('y', state.layers, ({
        accessors
      }) => accessors == null || accessors.length === 0 // has no accessor
      );
      if (!yLayerValidation.valid) {
        errors.push(yLayerValidation.error);
      }
      const breakDownLayerValidation = (0, _visualization_helpers.validateLayersForDimension)('break_down', state.layers, ({
        splitAccessor,
        seriesType
      }) => seriesType.includes('percentage') && splitAccessor == null // check if no split accessor
      );
      if (!breakDownLayerValidation.valid) {
        errors.push(breakDownLayerValidation.error);
      }
    }
    // temporary fix for #87068
    errors.push(...(0, _visualization_helpers.checkXAccessorCompatibility)(state, datasourceLayers).map(({
      shortMessage,
      longMessage
    }) => ({
      severity: 'error',
      uniqueId: _user_messages_ids.XY_X_WRONG_DATA_TYPE,
      fixableInEditor: true,
      displayLocations: [{
        id: 'visualization'
      }],
      shortMessage,
      longMessage
    })));
    for (const layer of (0, _visualization_helpers.getDataLayers)(state.layers)) {
      const datasourceAPI = datasourceLayers[layer.layerId];
      if (datasourceAPI) {
        for (const accessor of layer.accessors) {
          const operation = datasourceAPI.getOperationForColumnId(accessor);
          if (operation && operation.dataType !== 'number') {
            errors.push({
              uniqueId: _user_messages_ids.XY_Y_WRONG_DATA_TYPE,
              severity: 'error',
              fixableInEditor: true,
              displayLocations: [{
                id: 'visualization'
              }],
              shortMessage: _i18n.i18n.translate('xpack.lens.xyVisualization.dataTypeFailureYShort', {
                defaultMessage: `Wrong data type for {axis}.`,
                values: {
                  axis: (0, _visualization_helpers.getAxisName)('y', {
                    isHorizontal: (0, _state_helpers.isHorizontalChart)(state.layers)
                  })
                }
              }),
              longMessage: _i18n.i18n.translate('xpack.lens.xyVisualization.dataTypeFailureYLong', {
                defaultMessage: `The dimension {label} provided for the {axis} has the wrong data type. Expected number but have {dataType}`,
                values: {
                  label: operation.label,
                  dataType: operation.dataType,
                  axis: (0, _visualization_helpers.getAxisName)('y', {
                    isHorizontal: (0, _state_helpers.isHorizontalChart)(state.layers)
                  })
                }
              })
            });
          }
        }
      }
    }
    const warnings = [];
    if ((state === null || state === void 0 ? void 0 : state.layers.length) > 0 && activeData) {
      const filteredLayers = [...(0, _visualization_helpers.getDataLayers)(state.layers), ...(0, _visualization_helpers.getReferenceLayers)(state.layers)].filter(({
        accessors
      }) => accessors.length > 0);
      const accessorsWithArrayValues = [];
      for (const layer of filteredLayers) {
        const {
          layerId,
          accessors
        } = layer;
        const rows = (activeData === null || activeData === void 0 ? void 0 : activeData[layerId]) && activeData[layerId].rows;
        if (!rows) {
          break;
        }
        const columnToLabel = (0, _state_helpers.getColumnToLabelMap)(layer, datasourceLayers[layerId]);
        for (const accessor of accessors) {
          const hasArrayValues = rows.some(row => Array.isArray(row[accessor]));
          if (hasArrayValues) {
            accessorsWithArrayValues.push(columnToLabel[accessor]);
          }
        }
      }
      accessorsWithArrayValues.forEach(label => warnings.push({
        uniqueId: _user_messages_ids.XY_RENDER_ARRAY_VALUES,
        severity: 'warning',
        fixableInEditor: true,
        displayLocations: [{
          id: 'toolbar'
        }],
        shortMessage: '',
        longMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          key: label,
          id: "xpack.lens.xyVisualization.arrayValues",
          defaultMessage: "{label} contains array values. Your visualization may not render as expected.",
          values: {
            label: /*#__PURE__*/_react.default.createElement("strong", {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 964,
                columnNumber: 24
              }
            }, label)
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 959,
            columnNumber: 13
          }
        })
      }));
    }
    const shouldRotate = state !== null && state !== void 0 && state.layers.length ? (0, _state_helpers.isHorizontalChart)(state.layers) : false;
    const dataLayers = (0, _visualization_helpers.getDataLayers)(state.layers);
    const axisGroups = (0, _axes_configuration.getAxesConfiguration)(dataLayers, shouldRotate, frame.activeData);
    const logAxisGroups = axisGroups.filter(({
      groupId
    }) => groupId === 'left' && state.yLeftScale === 'log' || groupId === 'right' && state.yRightScale === 'log');
    if (logAxisGroups.length > 0) {
      logAxisGroups.map(axis => {
        const mixedDomainSeries = axis.series.filter(series => {
          var _activeData$series$la, _activeData$series$la2;
          let hasNegValues = false;
          let hasPosValues = false;
          const arr = (_activeData$series$la = activeData === null || activeData === void 0 ? void 0 : (_activeData$series$la2 = activeData[series.layer]) === null || _activeData$series$la2 === void 0 ? void 0 : _activeData$series$la2.rows) !== null && _activeData$series$la !== void 0 ? _activeData$series$la : [];
          for (let index = 0; index < arr.length; index++) {
            const value = arr[index][series.accessor];
            if (value < 0) {
              hasNegValues = true;
            } else {
              hasPosValues = true;
            }
            if (hasNegValues && hasPosValues) {
              return true;
            }
          }
          return false;
        });
        return {
          ...axis,
          mixedDomainSeries
        };
      }).forEach(axisGroup => {
        if (axisGroup.mixedDomainSeries.length === 0) return;
        const {
          groupId
        } = axisGroup;
        warnings.push({
          // TODO: can we push the group into the metadata and use a correct unique ID here?
          uniqueId: `${_user_messages_ids.XY_MIXED_LOG_SCALE}${groupId}`,
          severity: 'warning',
          shortMessage: '',
          longMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.lens.xyVisualization.mixedLogScaleWarning",
            defaultMessage: "When the {axisName} axis is set to logarithmic scale, the dataset should not contain positive and negative data.",
            values: {
              axisName: groupId === 'left' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.lens.xyVisualization.mixedLogScaleWarningLeft",
                defaultMessage: "left",
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 1025,
                  columnNumber: 23
                }
              }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.lens.xyVisualization.mixedLogScaleWarningRight",
                defaultMessage: "right",
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 1030,
                  columnNumber: 23
                }
              })
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 1019,
              columnNumber: 15
            }
          }),
          displayLocations: [{
            id: 'toolbar'
          }],
          fixableInEditor: true
        });
        axisGroup.mixedDomainSeries.forEach(({
          accessor
        }) => {
          warnings.push({
            // TODO: can we push the group into the metadata and use a correct unique ID here?
            uniqueId: `${_user_messages_ids.XY_MIXED_LOG_SCALE_DIMENSION}${accessor}`,
            severity: 'warning',
            shortMessage: '',
            longMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.lens.xyVisualization.mixedLogScaleDimensionWarning",
              defaultMessage: "This metric is using logarithmic scale and should not contain positive and negative data.",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 1049,
                columnNumber: 17
              }
            }),
            displayLocations: [{
              id: 'dimensionButton',
              dimensionId: accessor
            }],
            fixableInEditor: true
          });
        });
      });
    }
    const info = getNotifiableFeatures(state, frame, paletteService, fieldFormats);
    return errors.concat(warnings, info);
  },
  getUniqueLabels(state) {
    return (0, _helpers.getUniqueLabels)(state.layers);
  },
  getUsedDataView(state, layerId) {
    var _getAnnotationsLayers;
    return (_getAnnotationsLayers = (0, _visualization_helpers.getAnnotationsLayers)(state.layers).find(l => l.layerId === layerId)) === null || _getAnnotationsLayers === void 0 ? void 0 : _getAnnotationsLayers.indexPatternId;
  },
  getUsedDataViews(state) {
    var _state$layers$filter$;
    return (_state$layers$filter$ = state === null || state === void 0 ? void 0 : state.layers.filter(_visualization_helpers.isAnnotationsLayer).map(({
      indexPatternId
    }) => indexPatternId)) !== null && _state$layers$filter$ !== void 0 ? _state$layers$filter$ : [];
  },
  DimensionTriggerComponent({
    columnId,
    label
  }) {
    if (label) {
      return /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DimensionTrigger, {
        id: columnId,
        label: label || _helpers.defaultAnnotationLabel,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1079,
          columnNumber: 14
        }
      });
    }
    return null;
  },
  getSuggestionFromConvertToLensContext({
    suggestions,
    context
  }) {
    const allSuggestions = suggestions;
    const suggestion = {
      ...allSuggestions[0],
      datasourceState: {
        ...allSuggestions[0].datasourceState,
        layers: allSuggestions.reduce((acc, s) => {
          var _s$datasourceState;
          return {
            ...acc,
            ...((_s$datasourceState = s.datasourceState) === null || _s$datasourceState === void 0 ? void 0 : _s$datasourceState.layers)
          };
        }, {})
      },
      visualizationState: {
        ...allSuggestions[0].visualizationState,
        ...context.configuration
      }
    };
    return suggestion;
  },
  isEqual(persistedState1, references1, persistedState2, references2, annotationGroups) {
    const state1 = (0, _persistence.convertPersistedState)(persistedState1, annotationGroups, references1);
    const state2 = (0, _persistence.convertPersistedState)(persistedState2, annotationGroups, references2);
    return (0, _lodash.isEqual)(state1, state2);
  },
  getVisualizationInfo(state, frame) {
    return getVisualizationInfo(state, frame, paletteService, fieldFormats);
  },
  getTelemetryEventsOnSave(state, prevState) {
    const dataLayers = (0, _visualization_helpers.getDataLayers)(state.layers);
    const prevLayers = prevState ? (0, _visualization_helpers.getDataLayers)(prevState.layers) : undefined;
    const colorMappingEvents = dataLayers.flatMap(l => {
      const prevLayer = prevLayers === null || prevLayers === void 0 ? void 0 : prevLayers.find(prevL => prevL.layerId === l.layerId);
      return (0, _color_telemetry_helpers.getColorMappingTelemetryEvents)(l.colorMapping, prevLayer === null || prevLayer === void 0 ? void 0 : prevLayer.colorMapping);
    });
    const legendStatsEvents = (0, _legend_stats_telemetry_helpers.getLegendStatsTelemetryEvents)(state.legend.legendStats, prevState ? prevState.legend.legendStats : undefined);
    return colorMappingEvents.concat(legendStatsEvents);
  },
  getRenderEventCounters(state) {
    var _state$legend$legendS;
    if ((0, _legend_settings_popover.shouldDisplayTable)((_state$legend$legendS = state.legend.legendStats) !== null && _state$legend$legendS !== void 0 ? _state$legend$legendS : [])) {
      return [`legend_stats`];
    }
    return [];
  }
});
exports.getXyVisualization = getXyVisualization;
const getMappedAccessors = ({
  accessors,
  frame,
  fieldFormats,
  paletteService,
  state,
  layer
}) => {
  let mappedAccessors = accessors.map(accessor => ({
    columnId: accessor
  }));
  if (frame.activeData) {
    const colorAssignments = (0, _color_assignment.getColorAssignments)((0, _visualization_helpers.getDataLayers)(state.layers), {
      tables: frame.activeData
    }, fieldFormats.deserialize);
    mappedAccessors = (0, _color_assignment.getAccessorColorConfigs)(colorAssignments, frame, {
      ...layer,
      accessors: accessors.filter(sorted => layer.accessors.includes(sorted))
    }, paletteService);
  }
  return mappedAccessors;
};
function getVisualizationInfo(state, frame, paletteService, fieldFormats) {
  const isHorizontal = (0, _state_helpers.isHorizontalChart)(state.layers);
  const visualizationLayersInfo = state.layers.map(layer => {
    const palette = [];
    const dimensions = [];
    let chartType;
    let icon;
    let label;
    if ((0, _visualization_helpers.isDataLayer)(layer)) {
      chartType = layer.seriesType;
      const layerVisType = _types.visualizationSubtypes.find(visType => visType.id === chartType);
      icon = layerVisType === null || layerVisType === void 0 ? void 0 : layerVisType.icon;
      label = layerVisType === null || layerVisType === void 0 ? void 0 : layerVisType.label;
      if (layer.xAccessor) {
        dimensions.push({
          name: (0, _visualization_helpers.getAxisName)('x', {
            isHorizontal
          }),
          id: layer.xAccessor,
          dimensionType: 'x'
        });
      }
      if (layer.accessors && layer.accessors.length) {
        layer.accessors.forEach(accessor => {
          dimensions.push({
            name: (0, _visualization_helpers.getAxisName)('y', {
              isHorizontal
            }),
            id: accessor,
            dimensionType: 'y'
          });
        });
        if (frame !== null && frame !== void 0 && frame.datasourceLayers && frame.activeData) {
          const sortedAccessors = (0, _to_expression.getSortedAccessors)(frame.datasourceLayers[layer.layerId], layer);
          const mappedAccessors = getMappedAccessors({
            state,
            frame: frame,
            layer,
            fieldFormats,
            paletteService,
            accessors: sortedAccessors
          });
          palette.push(...mappedAccessors.flatMap(({
            color
          }) => color));
        }
      }
      if (layer.splitAccessor) {
        dimensions.push({
          name: _i18n.i18n.translate('xpack.lens.xyChart.splitSeries', {
            defaultMessage: 'Breakdown'
          }),
          dimensionType: 'breakdown',
          id: layer.splitAccessor
        });
        if (!layer.collapseFn) {
          var _layer$palette, _layer$palette2;
          palette.push(...paletteService.get(((_layer$palette = layer.palette) === null || _layer$palette === void 0 ? void 0 : _layer$palette.name) || 'default').getCategoricalColors(10, (_layer$palette2 = layer.palette) === null || _layer$palette2 === void 0 ? void 0 : _layer$palette2.params));
        }
      }
    }
    if ((0, _visualization_helpers.isReferenceLayer)(layer) && layer.accessors && layer.accessors.length) {
      layer.accessors.forEach(accessor => {
        dimensions.push({
          name: _i18n.i18n.translate('xpack.lens.xyChart.layerReferenceLine', {
            defaultMessage: 'Reference line'
          }),
          dimensionType: 'reference_line',
          id: accessor
        });
      });
      label = _i18n.i18n.translate('xpack.lens.xyChart.layerReferenceLineLabel', {
        defaultMessage: 'Reference lines'
      });
      icon = _chartIcons.IconChartBarReferenceLine;
      if (frame !== null && frame !== void 0 && frame.datasourceLayers && frame.activeData) {
        const sortedAccessors = (0, _to_expression.getSortedAccessors)(frame.datasourceLayers[layer.layerId], layer);
        palette.push(...(0, _reference_line_helpers.getReferenceConfiguration)({
          state,
          frame: frame,
          layer,
          sortedAccessors
        }).groups.flatMap(({
          accessors
        }) => accessors.map(({
          color
        }) => color)));
      }
    }
    if ((0, _visualization_helpers.isAnnotationsLayer)(layer) && layer.annotations && layer.annotations.length) {
      layer.annotations.forEach(annotation => {
        dimensions.push({
          name: _i18n.i18n.translate('xpack.lens.xyChart.layerAnnotation', {
            defaultMessage: 'Annotation'
          }),
          dimensionType: 'annotation',
          id: annotation.id
        });
      });
      label = _i18n.i18n.translate('xpack.lens.xyChart.layerAnnotationsLabel', {
        defaultMessage: 'Annotations'
      });
      icon = _chartIcons.IconChartBarAnnotations;
      palette.push(...layer.annotations.filter(({
        isHidden
      }) => !isHidden).map(annotation => (0, _eventAnnotationComponents.getAnnotationAccessor)(annotation).color));
    }
    const finalPalette = palette === null || palette === void 0 ? void 0 : palette.filter(_utils.nonNullable);
    return {
      layerId: layer.layerId,
      layerType: layer.layerType,
      chartType,
      icon,
      label,
      dimensions,
      palette: finalPalette.length ? finalPalette : undefined
    };
  });
  return {
    layers: visualizationLayersInfo
  };
}
function getNotifiableFeatures(state, frame, paletteService, fieldFormats) {
  const annotationsWithIgnoreFlag = (0, _visualization_helpers.getAnnotationsLayers)(state.layers).filter(layer => layer.ignoreGlobalFilters &&
  // If all annotations are manual, do not report it
  layer.annotations.some(annotation => annotation.type !== 'manual'));
  if (!annotationsWithIgnoreFlag.length) {
    return [];
  }
  const visualizationInfo = getVisualizationInfo(state, frame, paletteService, fieldFormats);
  return [{
    uniqueId: _user_messages_ids.LAYER_SETTINGS_IGNORE_GLOBAL_FILTERS,
    severity: 'info',
    fixableInEditor: false,
    shortMessage: _i18n.i18n.translate('xpack.lens.xyChart.layerAnnotationsIgnoreTitle', {
      defaultMessage: 'Layers ignoring global filters'
    }),
    longMessage: /*#__PURE__*/_react.default.createElement(_ignore_global_filter.IgnoredGlobalFiltersEntries, {
      layers: annotationsWithIgnoreFlag.map(({
        layerId,
        indexPatternId
      }) => ({
        layerId,
        indexPatternId
      })),
      visualizationInfo: visualizationInfo,
      dataViews: frame.dataViews,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 1338,
        columnNumber: 9
      }
    }),
    displayLocations: [{
      id: 'embeddableBadge'
    }]
  }];
}
const defaultSeriesTypesByIndex = ['bar', 'area', 'bar_horizontal'];
const stackingTypes = exports.stackingTypes = [{
  type: 'stacked',
  label: _i18n.i18n.translate('xpack.lens.shared.barLayerStacking.stacked', {
    defaultMessage: 'Stacked'
  }),
  subtypes: ['bar_stacked', 'area_stacked', 'bar_horizontal_stacked'],
  dataTestSubj: 'lnsStackingOptionsButtonStacked'
}, {
  type: 'unstacked',
  label: _i18n.i18n.translate('xpack.lens.shared.barLayerStacking.unstacked', {
    defaultMessage: 'Unstacked'
  }),
  subtypes: ['bar', 'area', 'bar_horizontal'],
  dataTestSubj: 'lnsStackingOptionsButtonUnstacked'
}, {
  type: 'percentage',
  label: _i18n.i18n.translate('xpack.lens.shared.barLayerStacking.percentage', {
    defaultMessage: 'Percentage'
  }),
  subtypes: ['bar_percentage_stacked', 'area_percentage_stacked', 'bar_horizontal_percentage_stacked'],
  dataTestSubj: 'lnsStackingOptionsButtonPercentage'
}];
const SubtypeSwitch = ({
  layer,
  setLayerState
}) => {
  const [flyoutOpen, setFlyoutOpen] = (0, _react.useState)(false);
  const stackingType = stackingTypes.find(({
    subtypes
  }) => subtypes.includes(layer.seriesType));
  if (!stackingType) {
    return null;
  }
  const subTypeIndex = stackingType.subtypes.indexOf(layer.seriesType);
  const options = stackingTypes.map(({
    label,
    subtypes,
    dataTestSubj
  }) => ({
    label,
    value: subtypes[subTypeIndex],
    checked: subtypes[subTypeIndex] === layer.seriesType ? 'on' : undefined,
    'data-test-subj': dataTestSubj
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
      "aria-label": _i18n.i18n.translate('xpack.lens.xyChart.stackingOptions', {
        defaultMessage: 'Stacking'
      }),
      onClick: () => setFlyoutOpen(true),
      fullWidth: true,
      size: "s",
      label: stackingType.label,
      "data-test-subj": "lnsStackingOptionsButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 1412,
        columnNumber: 11
      }
    }),
    isOpen: flyoutOpen,
    closePopover: () => setFlyoutOpen(false),
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1408,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    css: {
      width: 200
    },
    singleSelection: true,
    "data-test-subj": "lnsChartSwitchList",
    options: options,
    onChange: newOptions => {
      setFlyoutOpen(false);
      const chosenType = newOptions.find(({
        checked
      }) => checked === 'on');
      if (!chosenType) {
        return;
      }
      setLayerState({
        ...layer,
        seriesType: chosenType.value
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1427,
      columnNumber: 9
    }
  }, list => list)));
};