"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableDimensionDataExtraEditor = TableDimensionDataExtraEditor;
exports.TableDimensionEditor = TableDimensionEditor;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _coloring = require("@kbn/coloring");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _visualizationUtils = require("@kbn/visualization-utils");
var _transposeUtils = require("@kbn/transpose-utils");
var _expressions = require("../../../../common/expressions");
var _shared_components = require("../../../shared_components");
var _collapse_setting = require("../../../shared_components/collapse_setting");
var _color_mapping_by_values = require("../../../shared_components/coloring/color_mapping_by_values");
var _color_mapping_by_terms = require("../../../shared_components/coloring/color_mapping_by_terms");
var _utils = require("../utils");
var _utils2 = require("../../../../common/expressions/impl/datatable/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/datatable/components/dimension_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const idPrefix = (0, _eui.htmlIdGenerator)()();
function updateColumn(state, columnId, newColumn) {
  return state.columns.map(currentColumn => {
    if (currentColumn.columnId === columnId) {
      return {
        ...currentColumn,
        ...newColumn
      };
    } else {
      return currentColumn;
    }
  });
}
function TableDimensionEditor(props) {
  var _frame$activeData$loc, _frame$activeData, _frame$activeData2, _getDatatableColumn, _frame$datasourceLaye, _minMaxByColumnId$get, _column$palette, _activePalette$params;
  const {
    frame,
    accessor,
    isInlineEditing,
    isDarkMode,
    formatFactory
  } = props;
  const column = props.state.columns.find(({
    columnId
  }) => accessor === columnId);
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _visualizationUtils.useDebouncedValue)({
    value: props.state,
    onChange: props.setState
  });
  const updateColumnState = (0, _react.useCallback)((columnId, newColumn) => {
    setLocalState({
      ...localState,
      columns: updateColumn(localState, columnId, newColumn)
    });
  }, [setLocalState, localState]);
  if (!column) return null;
  if (column.isTransposed) return null;
  const currentData = (_frame$activeData$loc = (_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : _frame$activeData[localState.layerId]) !== null && _frame$activeData$loc !== void 0 ? _frame$activeData$loc : (_frame$activeData2 = frame.activeData) === null || _frame$activeData2 === void 0 ? void 0 : _frame$activeData2[_expressions.DatatableInspectorTables.Default];
  const columnMeta = (_getDatatableColumn = (0, _utils2.getDatatableColumn)(currentData, accessor)) === null || _getDatatableColumn === void 0 ? void 0 : _getDatatableColumn.meta;
  const formatter = formatFactory(columnMeta === null || columnMeta === void 0 ? void 0 : columnMeta.params);
  const allowCustomMatch = (0, _coloring.canCreateCustomMatch)(columnMeta);
  const datasource = (_frame$datasourceLaye = frame.datasourceLayers) === null || _frame$datasourceLaye === void 0 ? void 0 : _frame$datasourceLaye[localState.layerId];
  const {
    isNumeric,
    isCategory: isBucketable
  } = (0, _shared_components.getAccessorType)(datasource, accessor);
  const showColorByTerms = isBucketable;
  const showDynamicColoringFeature = isBucketable || isNumeric;
  const currentAlignment = (0, _utils.getColumnAlignment)(column, isNumeric);
  const currentColorMode = (column === null || column === void 0 ? void 0 : column.colorMode) || 'none';
  const hasDynamicColoring = currentColorMode !== 'none';
  const visibleColumnsCount = localState.columns.filter(c => !c.hidden).length;
  const hasTransposedColumn = localState.columns.some(({
    isTransposed
  }) => isTransposed);
  const columnsToCheck = hasTransposedColumn ? (currentData === null || currentData === void 0 ? void 0 : currentData.columns.filter(({
    id
  }) => (0, _transposeUtils.getOriginalId)(id) === accessor).map(({
    id
  }) => id)) || [] : [accessor];
  const minMaxByColumnId = (0, _shared_components.findMinMaxByColumnId)(columnsToCheck, currentData);
  const currentMinMax = (_minMaxByColumnId$get = minMaxByColumnId.get(accessor)) !== null && _minMaxByColumnId$get !== void 0 ? _minMaxByColumnId$get : (0, _coloring.getFallbackDataBounds)();
  const activePalette = {
    type: 'palette',
    name: showColorByTerms ? 'default' : _shared_components.defaultPaletteParams.name,
    ...(column === null || column === void 0 ? void 0 : column.palette),
    params: {
      ...(column === null || column === void 0 ? void 0 : (_column$palette = column.palette) === null || _column$palette === void 0 ? void 0 : _column$palette.params)
    }
  };
  // need to tell the helper that the colorStops are required to display
  const displayStops = (0, _coloring.applyPaletteParams)(props.paletteService, activePalette, currentMinMax);
  if (activePalette.name !== _coloring.CUSTOM_PALETTE && (_activePalette$params = activePalette.params) !== null && _activePalette$params !== void 0 && _activePalette$params.stops) {
    activePalette.params.stops = (0, _coloring.applyPaletteParams)(props.paletteService, activePalette, currentMinMax);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.table.alignment.label', {
      defaultMessage: 'Text alignment'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.table.alignment.label', {
      defaultMessage: 'Text alignment'
    }),
    "data-test-subj": "lnsDatatable_alignment_groups",
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}left`,
      label: _i18n.i18n.translate('xpack.lens.table.alignment.left', {
        defaultMessage: 'Left'
      }),
      'data-test-subj': 'lnsDatatable_alignment_groups_left'
    }, {
      id: `${idPrefix}center`,
      label: _i18n.i18n.translate('xpack.lens.table.alignment.center', {
        defaultMessage: 'Center'
      }),
      'data-test-subj': 'lnsDatatable_alignment_groups_center'
    }, {
      id: `${idPrefix}right`,
      label: _i18n.i18n.translate('xpack.lens.table.alignment.right', {
        defaultMessage: 'Right'
      }),
      'data-test-subj': 'lnsDatatable_alignment_groups_right'
    }],
    idSelected: `${idPrefix}${currentAlignment}`,
    onChange: id => {
      const newMode = id.replace(idPrefix, '');
      updateColumnState(accessor, {
        alignment: newMode
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  })), showDynamicColoringFeature && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.table.dynamicColoring.label', {
      defaultMessage: 'Color by value'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.table.dynamicColoring.label', {
      defaultMessage: 'Color by value'
    }),
    "data-test-subj": "lnsDatatable_dynamicColoring_groups",
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}none`,
      label: _i18n.i18n.translate('xpack.lens.table.dynamicColoring.none', {
        defaultMessage: 'None'
      }),
      'data-test-subj': 'lnsDatatable_dynamicColoring_groups_none'
    }, {
      id: `${idPrefix}cell`,
      label: _i18n.i18n.translate('xpack.lens.table.dynamicColoring.cell', {
        defaultMessage: 'Cell'
      }),
      'data-test-subj': 'lnsDatatable_dynamicColoring_groups_cell'
    }, {
      id: `${idPrefix}text`,
      label: _i18n.i18n.translate('xpack.lens.table.dynamicColoring.text', {
        defaultMessage: 'Text'
      }),
      'data-test-subj': 'lnsDatatable_dynamicColoring_groups_text'
    }],
    idSelected: `${idPrefix}${currentColorMode}`,
    onChange: id => {
      const newMode = id.replace(idPrefix, '');
      const params = {
        colorMode: newMode
      };
      if (newMode !== 'none') {
        if (!(column !== null && column !== void 0 && column.colorMapping) && showColorByTerms) {
          params.colorMapping = _coloring.DEFAULT_COLOR_MAPPING_CONFIG;
        }

        // also set palette for now
        if (!(column !== null && column !== void 0 && column.palette)) {
          params.palette = {
            ...activePalette,
            params: {
              ...activePalette.params,
              // that's ok, at first open we're going to throw them away and recompute
              stops: displayStops
            }
          };
        }
      }

      // clear up when switching to no coloring
      if (newMode === 'none') {
        params.palette = undefined;
        params.colorMapping = undefined;
      }
      updateColumnState(accessor, params);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 13
    }
  })), hasDynamicColoring && (showColorByTerms ? /*#__PURE__*/_react.default.createElement(_color_mapping_by_terms.ColorMappingByTerms, {
    isDarkMode: isDarkMode,
    colorMapping: column.colorMapping,
    palette: activePalette,
    palettes: props.palettes,
    isInlineEditing: isInlineEditing,
    setPalette: palette => {
      updateColumnState(accessor, {
        palette,
        colorMapping: undefined
      });
    },
    setColorMapping: colorMapping => {
      updateColumnState(accessor, {
        colorMapping
      });
    },
    paletteService: props.paletteService,
    panelRef: props.panelRef,
    categories: (0, _chartExpressionsCommon.getColorCategories)(currentData === null || currentData === void 0 ? void 0 : currentData.rows, accessor, [null]),
    formatter: formatter,
    allowCustomMatch: allowCustomMatch,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_color_mapping_by_values.ColorMappingByValues, {
    palette: activePalette,
    isInlineEditing: isInlineEditing,
    setPalette: newPalette => {
      updateColumnState(accessor, {
        palette: newPalette
      });
    },
    paletteService: props.paletteService,
    panelRef: props.panelRef,
    dataBounds: currentMinMax,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 15
    }
  }))), !column.isTransposed && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.table.columnVisibilityLabel', {
      defaultMessage: 'Hide column'
    }),
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.lens.table.columnVisibilityLabel', {
      defaultMessage: 'Hide column'
    }),
    showLabel: false,
    "data-test-subj": "lns-table-column-hidden",
    checked: Boolean(column === null || column === void 0 ? void 0 : column.hidden),
    disabled: !column.hidden && visibleColumnsCount <= 1,
    onChange: () => {
      const newState = {
        ...localState,
        columns: localState.columns.map(currentColumn => {
          if (currentColumn.columnId === accessor) {
            return {
              ...currentColumn,
              hidden: !column.hidden
            };
          } else {
            return currentColumn;
          }
        })
      };
      setLocalState(newState);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  })), props.groupId === 'rows' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.table.columnFilterClickLabel', {
      defaultMessage: 'Directly filter on click'
    }),
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.lens.table.columnFilterClickLabel', {
      defaultMessage: 'Directly filter on click'
    }),
    showLabel: false,
    "data-test-subj": "lns-table-column-one-click-filter",
    checked: Boolean(column === null || column === void 0 ? void 0 : column.oneClickFilter),
    disabled: column.hidden,
    onChange: () => {
      const newState = {
        ...localState,
        columns: localState.columns.map(currentColumn => {
          if (currentColumn.columnId === accessor) {
            return {
              ...currentColumn,
              oneClickFilter: !column.oneClickFilter
            };
          } else {
            return currentColumn;
          }
        })
      };
      setLocalState(newState);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 11
    }
  })));
}
function TableDimensionDataExtraEditor(props) {
  const {
    state,
    setState,
    accessor
  } = props;
  const column = state.columns.find(({
    columnId
  }) => accessor === columnId);
  if (!column) return null;
  if (column.isTransposed) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, props.groupId === 'rows' && /*#__PURE__*/_react.default.createElement(_collapse_setting.CollapseSetting, {
    value: column.collapseFn || '',
    onChange: collapseFn => {
      setState({
        ...state,
        columns: updateColumn(state, accessor, {
          collapseFn
        })
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 9
    }
  }));
}