"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiscoverHelpersAsync = exports.OpenInDiscoverDrilldown = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/data-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/trigger_actions/open_in_discover_drilldown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getDiscoverHelpersAsync = async () => await Promise.resolve().then(() => _interopRequireWildcard(require('../async_services')));
exports.getDiscoverHelpersAsync = getDiscoverHelpersAsync;
class OpenInDiscoverDrilldown {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", 'OPEN_IN_DISCOVER_DRILLDOWN');
    (0, _defineProperty2.default)(this, "order", 8);
    (0, _defineProperty2.default)(this, "getDisplayName", () => _i18n.i18n.translate('xpack.lens.app.exploreDataInDiscoverDrilldown', {
      defaultMessage: 'Open in Discover'
    }));
    (0, _defineProperty2.default)(this, "euiIcon", 'discoverApp');
    (0, _defineProperty2.default)(this, "ReactCollectConfig", ({
      config,
      onConfig
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        hasChildLabel: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        id: "openInNewTab",
        name: "openInNewTab",
        label: _i18n.i18n.translate('xpack.lens.app.exploreDataInDiscoverDrilldown.newTabConfig', {
          defaultMessage: 'Open in new tab'
        }),
        checked: config.openInNewTab,
        onChange: () => onConfig({
          ...config,
          openInNewTab: !config.openInNewTab
        }),
        "data-test-subj": "openInDiscoverDrilldownOpenInNewTab",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "CollectConfig", this.ReactCollectConfig);
    (0, _defineProperty2.default)(this, "createConfig", () => ({
      openInNewTab: true
    }));
    (0, _defineProperty2.default)(this, "isConfigValid", config => {
      return true;
    });
    (0, _defineProperty2.default)(this, "isCompatible", async (config, context) => {
      const {
        isCompatible
      } = await getDiscoverHelpersAsync();
      return isCompatible({
        locator: this.deps.locator(),
        dataViews: this.deps.dataViews(),
        hasDiscoverAccess: this.deps.hasDiscoverAccess(),
        ...context,
        embeddable: context.embeddable,
        ...config
      });
    });
    (0, _defineProperty2.default)(this, "isConfigurable", context => this.deps.hasDiscoverAccess() && (0, _presentationPublishing.apiIsOfType)(context.embeddable, _constants.DOC_TYPE));
    (0, _defineProperty2.default)(this, "getHref", async (config, context) => {
      const {
        getHref
      } = await getDiscoverHelpersAsync();
      return getHref({
        locator: this.deps.locator(),
        dataViews: this.deps.dataViews(),
        hasDiscoverAccess: this.deps.hasDiscoverAccess(),
        ...context,
        embeddable: context.embeddable
      });
    });
    (0, _defineProperty2.default)(this, "execute", async (config, context) => {
      if (config.openInNewTab) {
        window.open(await this.getHref(config, context), '_blank');
      } else {
        const {
          getLocation
        } = await getDiscoverHelpersAsync();
        const {
          app,
          path,
          state
        } = await getLocation({
          locator: this.deps.locator(),
          dataViews: this.deps.dataViews(),
          hasDiscoverAccess: this.deps.hasDiscoverAccess(),
          ...context,
          embeddable: context.embeddable
        });
        await this.deps.application().navigateToApp(app, {
          path,
          state
        });
      }
    });
    this.deps = deps;
  }
  supportedTriggers() {
    return [_public.APPLY_FILTER_TRIGGER];
  }
}
exports.OpenInDiscoverDrilldown = OpenInDiscoverDrilldown;