"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BarOrientationSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/bar_orientation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getBarOrientationOptions = isDisabled => [{
  id: `bar_orientation_horizontal`,
  value: 'horizontal',
  label: _i18n.i18n.translate('xpack.lens.shared.barOrientation.horizontal', {
    defaultMessage: 'Horizontal'
  }),
  'data-test-subj': 'lns_barOrientation_horizontal',
  toolTipContent: isDisabled ? _i18n.i18n.translate('xpack.lens.shared.barOrientation.disabled', {
    defaultMessage: 'A horizontal bar orientation cannot be applied when there are one or more area visualization layers.'
  }) : undefined
}, {
  id: `bar_orientation_vertical`,
  value: 'vertical',
  label: _i18n.i18n.translate('xpack.lens.shared.barOrientation.vertical', {
    defaultMessage: 'Vertical'
  }),
  'data-test-subj': 'lns_barOrientation_vertical'
}];
const BarOrientationSettings = ({
  barOrientation = 'horizontal',
  onBarOrientationChange,
  isDisabled = false
}) => {
  var _barOrientationOption;
  const barOrientationOptions = getBarOrientationOptions(isDisabled);
  const label = _i18n.i18n.translate('xpack.lens.shared.barOrientation', {
    defaultMessage: 'Bar orientation'
  });
  const isSelected = ((_barOrientationOption = barOrientationOptions.find(({
    value
  }) => value === barOrientation)) === null || _barOrientationOption === void 0 ? void 0 : _barOrientationOption.id) || 'bar_orientation_horizontal';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: label,
    fullWidth: true,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isDisabled: isDisabled,
    isFullWidth: true,
    legend: label,
    "data-test-subj": "lns_barOrientation",
    buttonSize: "compressed",
    options: barOrientationOptions,
    idSelected: isSelected,
    onChange: modeId => {
      const newMode = barOrientationOptions.find(({
        id
      }) => id === modeId);
      if (newMode) {
        onBarOrientationChange(newMode.value);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }));
};
exports.BarOrientationSettings = BarOrientationSettings;