"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLEditor = ESQLEditor;
var _reactDom = require("react-dom");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/esql/public");
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _use_current_attributes = require("../../../app_plugin/shared/edit_on_the_fly/use_current_attributes");
var _shared_logic = require("../../../state_management/shared_logic");
var _state_management = require("../../../state_management");
var _helpers = require("../../../app_plugin/shared/edit_on_the_fly/helpers");
var _use_esql_variables = require("../../../app_plugin/shared/edit_on_the_fly/use_esql_variables");
var _utils = require("../../../datasources/form_based/esql_layer/utils");
var _types = require("../../../react_embeddable/types");
var _esql_data_grid_accordion = require("../../../app_plugin/shared/edit_on_the_fly/esql_data_grid_accordion");
var _use_initialize_chart = require("./use_initialize_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/config_panel/esql_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * This is a wrapper around the Monaco ESQL editor for Lens
 * It handles its internal state and update both attributes & activeData on changes
 * in the Redux store.
 * Mind that this component will render either inline (classic React)
 * or in a portal if the editorContainer props is provided
 */
function ESQLEditor({
  data,
  uiSettings,
  attributes,
  framePublicAPI,
  isTextBasedLanguage,
  datasourceMap,
  visualizationMap,
  lensAdapters,
  parentApi,
  panelId,
  layerId,
  closeFlyout,
  editorContainer,
  canEditTextBasedQuery,
  dataLoading$,
  setCurrentAttributes,
  updateSuggestion
}) {
  const prevQuery = (0, _react.useRef)((attributes === null || attributes === void 0 ? void 0 : attributes.state.query) || {
    esql: ''
  });
  const [query, setQuery] = (0, _react.useState)((attributes === null || attributes === void 0 ? void 0 : attributes.state.query) || {
    esql: ''
  });
  const {
    visualization
  } = (0, _state_management.useLensSelector)(state => state.lens);
  const [errors, setErrors] = (0, _react.useState)([]);
  const [isLayerAccordionOpen, setIsLayerAccordionOpen] = (0, _react.useState)(true);
  const [suggestsLimitedColumns, setSuggestsLimitedColumns] = (0, _react.useState)(false);
  const [isVisualizationLoading, setIsVisualizationLoading] = (0, _react.useState)(false);
  const [dataGridAttrs, setDataGridAttrs] = (0, _react.useState)(undefined);
  const [isSuggestionsAccordionOpen, setIsSuggestionsAccordionOpen] = (0, _react.useState)(false);
  const [isESQLResultsAccordionOpen, setIsESQLResultsAccordionOpen] = (0, _react.useState)(false);
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  const currentAttributes = (0, _use_current_attributes.useCurrentAttributes)({
    textBasedMode: isTextBasedLanguage,
    initialAttributes: attributes,
    datasourceMap,
    visualizationMap
  });
  const adHocDataViews = attributes && attributes.state.adHocDataViews ? Object.values(attributes.state.adHocDataViews) : Object.values(framePublicAPI.dataViews.indexPatterns).map(index => index.spec);
  const previousAdapters = (0, _react.useRef)(lensAdapters);
  const esqlVariables = (0, _presentationPublishing.useStateFromPublishingSubject)((0, _types.isApiESQLVariablesCompatible)(parentApi) ? parentApi === null || parentApi === void 0 ? void 0 : parentApi.esqlVariables$ : new _rxjs.BehaviorSubject(undefined));
  const dispatch = (0, _state_management.useLensDispatch)();
  (0, _react.useEffect)(() => {
    const s = dataLoading$ === null || dataLoading$ === void 0 ? void 0 : dataLoading$.subscribe(isDataLoading => {
      var _previousAdapters$cur, _previousAdapters$cur2;
      // go thru only when the loading is complete
      if (isDataLoading) {
        return;
      }
      const activeData = (0, _shared_logic.getActiveDataFromDatatable)(layerId, (_previousAdapters$cur = previousAdapters.current) === null || _previousAdapters$cur === void 0 ? void 0 : (_previousAdapters$cur2 = _previousAdapters$cur.tables) === null || _previousAdapters$cur2 === void 0 ? void 0 : _previousAdapters$cur2.tables);
      const table = activeData === null || activeData === void 0 ? void 0 : activeData[layerId];
      if (table) {
        // there are cases where a query can return a big amount of columns
        // at this case we don't suggest all columns in a table but the first `MAX_NUM_OF_COLUMNS`
        setSuggestsLimitedColumns(table.columns.length >= _utils.MAX_NUM_OF_COLUMNS);
      }
      if (Object.keys(activeData).length > 0) {
        dispatch((0, _state_management.onActiveDataChange)({
          activeData
        }));
      }
    });
    return () => s === null || s === void 0 ? void 0 : s.unsubscribe();
  }, [dataLoading$, dispatch, layerId]);
  const runQuery = (0, _react.useCallback)(async (q, abortController, shouldUpdateAttrs) => {
    const attrs = await (0, _helpers.getSuggestions)(q, data, uiSettings, datasourceMap, visualizationMap, adHocDataViews, setErrors, abortController, setDataGridAttrs, esqlVariables, shouldUpdateAttrs, currentAttributes);
    if (attrs) {
      setCurrentAttributes === null || setCurrentAttributes === void 0 ? void 0 : setCurrentAttributes(attrs);
      setErrors([]);
      updateSuggestion === null || updateSuggestion === void 0 ? void 0 : updateSuggestion(attrs);
    }
    prevQuery.current = q;
    setIsVisualizationLoading(false);
  }, [uiSettings, data, datasourceMap, visualizationMap, adHocDataViews, esqlVariables, currentAttributes, setCurrentAttributes, updateSuggestion]);
  (0, _use_initialize_chart.useInitializeChart)({
    isTextBasedLanguage,
    query,
    dataGridAttrs,
    isInitialized,
    currentAttributes,
    runQuery,
    prevQueryRef: prevQuery,
    setErrors,
    setIsInitialized
  });

  // Early exit if it's not in TextBased mode
  if (!isTextBasedLanguage || !canEditTextBasedQuery || !(0, _esQuery.isOfAggregateQueryType)(query)) {
    return null;
  }
  const EditorComponent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(InnerESQLEditor, {
    query: query,
    prevQuery: prevQuery,
    setQuery: setQuery,
    runQuery: runQuery,
    adHocDataViews: adHocDataViews,
    errors: errors,
    suggestsLimitedColumns: suggestsLimitedColumns,
    isVisualizationLoading: isVisualizationLoading,
    setIsVisualizationLoading: setIsVisualizationLoading,
    esqlVariables: esqlVariables,
    closeFlyout: closeFlyout,
    panelId: panelId,
    attributes: attributes,
    parentApi: parentApi,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }), dataGridAttrs ? /*#__PURE__*/_react.default.createElement(_esql_data_grid_accordion.ESQLDataGridAccordion, {
    dataGridAttrs: dataGridAttrs,
    isAccordionOpen: isESQLResultsAccordionOpen,
    isTableView: visualization.activeId !== 'lnsDatatable',
    setIsAccordionOpen: setIsESQLResultsAccordionOpen,
    query: query,
    onAccordionToggleCb: status => {
      if (status && isSuggestionsAccordionOpen) {
        setIsSuggestionsAccordionOpen(!status);
      }
      if (status && isLayerAccordionOpen) {
        setIsLayerAccordionOpen(!status);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  }) : null);
  if (editorContainer) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/(0, _reactDom.createPortal)(EditorComponent, editorContainer));
  }
  return EditorComponent;
}
function InnerESQLEditor({
  query,
  adHocDataViews,
  errors,
  suggestsLimitedColumns,
  attributes,
  parentApi,
  panelId,
  closeFlyout,
  setQuery,
  isVisualizationLoading,
  setIsVisualizationLoading,
  prevQuery,
  runQuery,
  esqlVariables
}) {
  var _adHocDataViews$;
  const {
    onSaveControl,
    onCancelControl
  } = (0, _use_esql_variables.useESQLVariables)({
    parentApi,
    panelId,
    attributes,
    closeFlyout
  });
  const hideTimeFilterInfo = false;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "InlineEditingESQLEditor",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ESQLLangEditor, {
    query: query,
    onTextLangQueryChange: setQuery,
    detectedTimestamp: adHocDataViews === null || adHocDataViews === void 0 ? void 0 : (_adHocDataViews$ = adHocDataViews[0]) === null || _adHocDataViews$ === void 0 ? void 0 : _adHocDataViews$.timeFieldName,
    hideTimeFilterInfo: hideTimeFilterInfo,
    errors: errors,
    warning: suggestsLimitedColumns ? _i18n.i18n.translate('xpack.lens.config.configFlyoutCallout', {
      defaultMessage: 'Displaying a limited portion of the available fields. Add more from the configuration panel.'
    }) : undefined,
    editorIsInline: true,
    hideRunQueryText: true,
    onTextLangQuerySubmit: async (q, a) => {
      // do not run the suggestions if the query is the same as the previous one
      if (q && !(0, _lodash.isEqual)(q, prevQuery.current)) {
        setIsVisualizationLoading(true);
        await runQuery(q, a);
      }
    },
    isDisabled: false,
    allowQueryCancellation: true,
    isLoading: isVisualizationLoading,
    controlsContext: {
      supportsControls: parentApi !== undefined,
      onSaveControl,
      onCancelControl
    },
    esqlVariables: esqlVariables,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 7
    }
  }));
}