"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertTagcloudToRawColorMappings = void 0;
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Old color mapping state meant for type safety during runtime migrations of old configurations
 *
 * @deprecated
 */

const convertTagcloudToRawColorMappings = (state, datasourceStates) => {
  const getColumnMeta = (0, _common.getColumnMetaFn)(datasourceStates);
  const hasDeprecatedColorMapping = state.colorMapping ? (0, _common.isDeprecatedColorMapping)(state.colorMapping) : false;
  if (!hasDeprecatedColorMapping) return state;
  const columnMeta = state.tagAccessor ? getColumnMeta === null || getColumnMeta === void 0 ? void 0 : getColumnMeta(state.layerId, state.tagAccessor) : null;
  return {
    ...state,
    colorMapping: state.colorMapping && (0, _common.convertToRawColorMappings)(state.colorMapping, columnMeta)
  };
};
exports.convertTagcloudToRawColorMappings = convertTagcloudToRawColorMappings;