"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClustersTable = ClustersTable;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _cluster_view = require("./cluster_view");
var _clusters_health = require("../clusters_health");
var _local_cluster = require("../local_cluster");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/inspector/public/views/requests/components/details/clusters_view/clusters_table/clusters_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getInitialExpandedRow(clusters) {
  const clusterNames = Object.keys(clusters);
  return clusterNames.length === 1 ? {
    [clusterNames[0]]: /*#__PURE__*/_react.default.createElement(_cluster_view.ClusterView, {
      clusterDetails: clusters[clusterNames[0]],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 28
      }
    })
  } : {};
}
function ClustersTable({
  clusters
}) {
  const [expandedRows, setExpandedRows] = (0, _react.useState)(getInitialExpandedRow(clusters));
  const [sortField, setSortField] = (0, _react.useState)();
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const toggleDetails = name => {
    const nextExpandedRows = {
      ...expandedRows
    };
    if (name in nextExpandedRows) {
      delete nextExpandedRows[name];
    } else {
      nextExpandedRows[name] = /*#__PURE__*/_react.default.createElement(_cluster_view.ClusterView, {
        clusterDetails: clusters[name],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 32
        }
      });
    }
    setExpandedRows(nextExpandedRows);
  };
  const items = (0, _react.useMemo)(() => {
    return Object.keys(clusters).map(key => {
      return {
        name: key,
        status: clusters[key].status,
        responseTime: clusters[key].took
      };
    });
  }, [clusters]);
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('inspector.requests.clusters.table.nameLabel', {
      defaultMessage: 'Name'
    }),
    render: name => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": `inspectorRequestToggleClusterDetails${name}`,
        onClick: () => toggleDetails(name),
        "aria-label": name in expandedRows ? _i18n.i18n.translate('inspector.requests.clusters.table.collapseRow', {
          defaultMessage: 'Collapse table row to hide cluster details'
        }) : _i18n.i18n.translate('inspector.requests.clusters.table.expandRow', {
          defaultMessage: 'Expand table row to view cluster details'
        }),
        iconType: name in expandedRows ? 'arrowDown' : 'arrowRight',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 13
        }
      }, name === _local_cluster.LOCAL_CLUSTER_KEY ? _i18n.i18n.translate('inspector.requests.clusters.table.localClusterDisplayName', {
        defaultMessage: 'Local cluster'
      }) : name));
    },
    sortable: items.length > 1,
    width: '60%'
  }, {
    field: 'status',
    name: _i18n.i18n.translate('inspector.requests.clusters.table.statusLabel', {
      defaultMessage: 'Status'
    }),
    render: status => {
      return /*#__PURE__*/_react.default.createElement(_clusters_health.ClusterHealth, {
        status: status,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 16
        }
      });
    },
    sortable: items.length > 1
  }, {
    align: 'right',
    field: 'responseTime',
    name: _i18n.i18n.translate('inspector.requests.clusters.table.responseTimeLabel', {
      defaultMessage: 'Response time'
    }),
    render: responseTime => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    }, responseTime ? _i18n.i18n.translate('inspector.requests.clusters.table.responseTimeInMilliseconds', {
      defaultMessage: '{responseTime}ms',
      values: {
        responseTime
      }
    }) : null),
    sortable: items.length > 1
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: sortField ? items.sort(_eui.Comparators.property(sortField, _eui.Comparators.default(sortDirection))) : items,
    itemIdToExpandedRowMap: expandedRows,
    itemId: "name",
    columns: columns,
    sorting: {
      sort: sortField ? {
        field: sortField,
        direction: sortDirection
      } : undefined
    },
    onChange: ({
      sort
    }) => {
      if (sort) {
        setSortField(sort.field);
        setSortDirection(sort.direction);
      }
    },
    noItemsMessage: _i18n.i18n.translate('inspector.requests.clusters.table.noItemsFound', {
      defaultMessage: 'No clusters found'
    }),
    cellProps: (item, column) => ({
      'data-test-subj': `inspectorRequestClustersTableCell-${column.name}-${item.name}`
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  });
}