"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMac = exports.isKeyboardShortcut = exports.isEscapeKey = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Check if single quote was pressed.
 * @param {KeyboardEvent} event The keyboard event.
 * @return {boolean} 'true' if the keyboard shortcut is pressed, 'false' otherwise.
 */
const isSingleQuote = event => event.code === 'Quote' || event.key === "'";

/**
 * Check if the keyboard event corresponds to the defined keyboard shortcut (Meta/Ctrl + ').
 * @param {KeyboardEvent} event The keyboard event.
 * @return {boolean} 'true' if the keyboard shortcut is pressed, 'false' otherwise.
 */
const isKeyboardShortcut = event => (event.metaKey || event.ctrlKey) && isSingleQuote(event);

/**
 * Check if the current platform is macOS.
 * @return {boolean} 'true' if the platform is macOS, 'false' otherwise.
 */
exports.isKeyboardShortcut = isKeyboardShortcut;
const isMac = () => {
  var _navigator, _navigator$userAgentD;
  return (((_navigator = navigator) === null || _navigator === void 0 ? void 0 : (_navigator$userAgentD = _navigator.userAgentData) === null || _navigator$userAgentD === void 0 ? void 0 : _navigator$userAgentD.platform) || navigator.userAgent).toLowerCase().includes('mac');
};

/**
 * Check if Escape key was pressed.
 * @return {boolean} 'true' if Escape key was pressed, 'false' otherwise.
 */
exports.isMac = isMac;
const isEscapeKey = event => event.key === 'Escape';
exports.isEscapeKey = isEscapeKey;