"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDatabaseValue = exports.getDatabaseText = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDatabaseNameOptions = type => {
  switch (type) {
    case 'maxmind':
      return _constants.GEOIP_NAME_OPTIONS;
    case 'ipinfo':
      return _constants.IPINFO_NAME_OPTIONS;
    case undefined:
      return [..._constants.GEOIP_NAME_OPTIONS, ..._constants.IPINFO_NAME_OPTIONS];
    default:
      return [];
  }
};

/**
 * Returns the value/id of the database, if it exists.
 *
 * @param databaseText The human-readable name of the database
 * @param type If specified, searches only in the database name options for this type
 */
const getDatabaseValue = (databaseText, type) => {
  var _options$find;
  const options = getDatabaseNameOptions(type);
  return (_options$find = options.find(opt => opt.text === databaseText)) === null || _options$find === void 0 ? void 0 : _options$find.value;
};

/**
 * Returns the human-readable name of the database, if it exists.
 *
 * @param databaseText The id/value of the database
 * @param type If specified, searches only in the database name options for this type
 */
exports.getDatabaseValue = getDatabaseValue;
const getDatabaseText = (databaseValue, type) => {
  var _options$find2;
  const options = getDatabaseNameOptions(type);
  return (_options$find2 = options.find(opt => opt.value === databaseValue)) === null || _options$find2 === void 0 ? void 0 : _options$find2.text;
};
exports.getDatabaseText = getDatabaseText;