"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initMetricsExplorerViewRoutes = void 0;
var _create_metrics_explorer_view = require("./create_metrics_explorer_view");
var _delete_metrics_explorer_view = require("./delete_metrics_explorer_view");
var _find_metrics_explorer_view = require("./find_metrics_explorer_view");
var _get_metrics_explorer_view = require("./get_metrics_explorer_view");
var _update_metrics_explorer_view = require("./update_metrics_explorer_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initMetricsExplorerViewRoutes = dependencies => {
  if (!dependencies.framework.config.featureFlags.metricsExplorerEnabled) {
    return;
  }
  (0, _create_metrics_explorer_view.initCreateMetricsExplorerViewRoute)(dependencies);
  (0, _delete_metrics_explorer_view.initDeleteMetricsExplorerViewRoute)(dependencies);
  (0, _find_metrics_explorer_view.initFindMetricsExplorerViewRoute)(dependencies);
  (0, _get_metrics_explorer_view.initGetMetricsExplorerViewRoute)(dependencies);
  (0, _update_metrics_explorer_view.initUpdateMetricsExplorerViewRoute)(dependencies);
};
exports.initMetricsExplorerViewRoutes = initMetricsExplorerViewRoutes;