"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsEditMode = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _get_custom_metric_label = require("../../../../../../../common/formatters/get_custom_metric_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/metric_control/metrics_edit_mode.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ICON_WIDTH = 36;
const MetricsEditMode = exports.MetricsEditMode = (0, _eui.withEuiTheme)(({
  theme,
  customMetrics,
  options,
  onEdit,
  onDelete
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 256
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, options.map(option => /*#__PURE__*/_react.default.createElement("div", {
    key: option.value,
    style: {
      padding: '14px 14px 13px 36px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    style: {
      color: theme === null || theme === void 0 ? void 0 : theme.euiTheme.colors.disabled
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 13
    }
  }, option.text))), customMetrics.map(metric => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    key: metric.id,
    alignItems: "center",
    gutterSize: "none",
    style: {
      padding: '10px 0px 9px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: ICON_WIDTH
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraMetricsEditModeButton",
    iconType: "pencil",
    onClick: () => onEdit(metric),
    "aria-label": _i18n.i18n.translate('xpack.infra.waffle.customMetrics.editMode.editButtonAriaLabel', {
      defaultMessage: 'Edit custom metric for {name}',
      values: {
        name: (0, _get_custom_metric_label.getCustomMetricLabel)(metric)
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    style: {
      overflow: 'hidden'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, (0, _get_custom_metric_label.getCustomMetricLabel)(metric)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: ICON_WIDTH,
      textAlign: 'right'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraMetricsEditModeButton",
    iconType: "trash",
    color: "danger",
    onClick: () => onDelete(metric),
    "aria-label": _i18n.i18n.translate('xpack.infra.waffle.customMetrics.editMode.deleteAriaLabel', {
      defaultMessage: 'Delete custom metric for {name}',
      values: {
        name: (0, _get_custom_metric_label.getCustomMetricLabel)(metric)
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 15
    }
  })))));
});