"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedViews = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_inventory_views = require("../hooks/use_inventory_views");
var _toolbar_control = require("../../../../components/saved_views/toolbar_control");
var _use_waffle_filters = require("../hooks/use_waffle_filters");
var _use_waffle_options = require("../hooks/use_waffle_options");
var _use_waffle_time = require("../hooks/use_waffle_time");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/saved_views.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SavedViews = () => {
  const {
    currentView,
    views,
    isFetchingViews,
    isFetchingCurrentView,
    isCreatingView,
    isUpdatingView,
    createView,
    deleteViewById,
    fetchViews,
    updateViewById,
    switchViewById,
    setDefaultViewById
  } = (0, _use_inventory_views.useInventoryViewsContext)();
  const {
    metric,
    groupBy,
    nodeType,
    view,
    customOptions,
    customMetrics,
    boundsOverride,
    autoBounds,
    accountId,
    region,
    legend,
    sort,
    timelineOpen,
    preferredSchema
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    currentTime,
    isAutoReloading
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    filterQuery
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  return /*#__PURE__*/_react.default.createElement(_toolbar_control.SavedViewsToolbarControls, {
    currentView: currentView,
    views: views,
    isFetchingViews: isFetchingViews,
    isFetchingCurrentView: isFetchingCurrentView,
    isCreatingView: isCreatingView,
    isUpdatingView: isUpdatingView,
    onCreateView: createView,
    onDeleteView: deleteViewById,
    onUpdateView: updateViewById,
    onLoadViews: fetchViews,
    onSetDefaultView: setDefaultViewById,
    onSwitchView: switchViewById,
    viewState: {
      metric,
      groupBy,
      nodeType,
      view,
      customOptions,
      customMetrics,
      boundsOverride,
      autoBounds,
      accountId,
      region,
      legend,
      sort,
      timelineOpen,
      time: currentTime,
      autoReload: isAutoReloading,
      // retrocompatibility with saved views
      filterQuery: {
        expression: filterQuery.query,
        kind: filterQuery.language
      },
      preferredSchema
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  });
};
exports.SavedViews = SavedViews;