"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTabContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public = require("@kbn/observability-plugin/public");
var _reactHooks = require("@kbn/react-hooks");
var _constants = require("../../../../../../../common/constants");
var _use_kibana = require("../../../../../../hooks/use_kibana");
var _height_retainer = require("../../../../../../components/height_retainer");
var _use_unified_search = require("../../../hooks/use_unified_search");
var _use_alerts_query = require("../../../hooks/use_alerts_query");
var _constants2 = require("../../../../../../components/shared/alerts/constants");
var _alerts_status_filter = _interopRequireDefault(require("../../../../../../components/shared/alerts/alerts_status_filter"));
var _create_alert_rule_button = require("../../../../../../components/shared/alerts/links/create_alert_rule_button");
var _link_to_alerts_page = require("../../../../../../components/shared/alerts/links/link_to_alerts_page");
var _alert_flyout = require("../../../../../../alerting/inventory/components/alert_flyout");
var _plugin_config_context = require("../../../../../../containers/plugin_config_context");
var _use_hosts_view = require("../../../hooks/use_hosts_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/tabs/alerts/alerts_tab_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertsTabContent = () => {
  const {
    featureFlags
  } = (0, _plugin_config_context.usePluginConfig)();
  const {
    hostNodes
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    cases,
    settings
  } = services;
  const {
    alertStatus,
    setAlertStatus,
    alertsEsQueryByStatus
  } = (0, _use_alerts_query.useAlertsQuery)();
  const [isAlertFlyoutVisible, {
    toggle: toggleAlertFlyout
  }] = (0, _reactHooks.useBoolean)(false);
  const {
    onDateRangeChange,
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const hostNamesKuery = hostNodes.map(host => `host.name: "${host.name}"`).join(' OR ');
  return /*#__PURE__*/_react.default.createElement(_height_retainer.HeightRetainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "hostsView-alerts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_status_filter.default, {
    onChange: setAlertStatus,
    status: alertStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, featureFlags.inventoryThresholdAlertRuleEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_create_alert_rule_button.CreateAlertRuleButton, {
    onClick: toggleAlertFlyout,
    "data-test-subj": "infraHostAlertsTabCreateAlertsRuleButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_link_to_alerts_page.LinkToAlertsPage, {
    dateRange: searchCriteria.dateRange,
    "data-test-subj": "infraHostAlertsTabAlertsShowAllButton",
    kuery: hostNamesKuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(MemoAlertSummaryWidget, {
    alertsQuery: alertsEsQueryByStatus,
    dateRange: searchCriteria.dateRange,
    onRangeSelection: onDateRangeChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  })), alertsEsQueryByStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ObservabilityAlertsTable, {
    id: _constants2.ALERTS_TABLE_ID,
    ruleTypeIds: _ruleDataUtils.OBSERVABILITY_RULE_TYPE_IDS,
    consumers: _constants.INFRA_ALERT_CONSUMERS,
    pageSize: _constants2.ALERTS_PER_PAGE,
    query: alertsEsQueryByStatus,
    services: {
      data,
      http,
      notifications,
      fieldFormats,
      application,
      licensing,
      cases,
      settings
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }))), featureFlags.inventoryThresholdAlertRuleEnabled && /*#__PURE__*/_react.default.createElement(_alert_flyout.AlertFlyout, {
    nodeType: "host",
    setVisible: toggleAlertFlyout,
    visible: isAlertFlyoutVisible,
    schema: searchCriteria.preferredSchema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }));
};
exports.AlertsTabContent = AlertsTabContent;
const MemoAlertSummaryWidget = /*#__PURE__*/_react.default.memo(({
  alertsQuery,
  dateRange,
  onRangeSelection
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const summaryTimeRange = (0, _public.useSummaryTimeRange)(dateRange);
  const {
    charts,
    triggersActionsUi
  } = services;
  const {
    getAlertSummaryWidget: AlertSummaryWidget
  } = triggersActionsUi;
  const onBrushEnd = brushEvent => {
    const {
      x
    } = brushEvent;
    if (x) {
      const [start, end] = x;
      const from = new Date(start).toISOString();
      const to = new Date(end).toISOString();
      onRangeSelection({
        from,
        to
      });
    }
  };
  const chartProps = {
    baseTheme: charts.theme.useChartsBaseTheme(),
    onBrushEnd
  };
  return /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    chartProps: chartProps,
    ruleTypeIds: _ruleDataUtils.OBSERVABILITY_RULE_TYPE_IDS,
    consumers: _constants.INFRA_ALERT_CONSUMERS,
    filter: alertsQuery,
    fullSize: true,
    timeRange: summaryTimeRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  });
});