"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataTroubleshootingPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _constants = require("../../../../../components/asset_details/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/table/add_data_troubleshooting_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const popoverContent = {
  title: _i18n.i18n.translate('xpack.infra.addDataPopover.wantToSeeMorePopoverTitleLabel', {
    defaultMessage: 'Want to see more?'
  }),
  content: _i18n.i18n.translate('xpack.infra.addDataPopover.understandHostPerformanceByTextLabel', {
    defaultMessage: 'Understand host performance by collecting more metrics.'
  }),
  button: _i18n.i18n.translate('xpack.infra.addDataPopover.understandHostPerformanceByTextLabel', {
    defaultMessage: 'Add data'
  }),
  link: _i18n.i18n.translate('xpack.infra.addDataPopover.troubleshootingLinkLabel', {
    defaultMessage: 'Troubleshooting'
  })
};
const badgeContent = _i18n.i18n.translate('xpack.infra.addDataPopover.naBadgeLabel', {
  defaultMessage: 'N/A'
});
const AddDataTroubleshootingPopover = () => {
  var _share$url$locators$g;
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const {
    services: {
      share
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const addDataLinkHref = (_share$url$locators$g = share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR)) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.getRedirectUrl({
    category: 'host'
  });
  const onButtonClick = () => togglePopover();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      iconType: "info",
      iconSide: "left",
      onClick: onButtonClick,
      onClickAriaLabel: popoverContent.title,
      iconOnClick: onButtonClick,
      iconOnClickAriaLabel: popoverContent.title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, badgeContent),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, popoverContent.title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    style: {
      width: 300
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, popoverContent.content), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    href: addDataLinkHref,
    "data-test-subj": "infraHostsTableWithoutSystemMetricsPopoverAddMoreButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }, popoverContent.button)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _constants.APM_HOST_TROUBLESHOOTING_LINK,
    target: "_blank",
    "data-test-subj": "infraHostsTableWithoutSystemMetricsPopoverTroubleshootingLink",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  }, popoverContent.link))))));
};
exports.AddDataTroubleshootingPopover = AddDataTroubleshootingPopover;