"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogViewErrorPage = exports.LogSourceErrorPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-utils-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _common2 = require("@kbn/logs-shared-plugin/common");
var _page_template = require("./page_template");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/shared/page_log_view_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LogViewErrorPage = ({
  errors,
  onRetry
}) => {
  const settingsLinkProps = (0, _public.useLinkProps)({
    app: 'logs',
    pathname: '/settings'
  });
  return /*#__PURE__*/_react.default.createElement(_page_template.LogsPageTemplate, {
    isEmptyState: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    iconColor: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceErrorPage.failedToLoadSourceTitle",
      defaultMessage: "Failed to load configuration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 13
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceErrorPage.failedToLoadSourceMessage",
      defaultMessage: "Errors occurred while attempting to load the configuration. Try again or change the configuration to fix the problem.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 15
      }
    })), errors.map(error => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: error.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(LogSourceErrorMessage, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 17
      }
    })))),
    actions: onRetry ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraLogViewErrorPageTryAgainButton",
      onClick: onRetry,
      iconType: "refresh",
      fill: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceErrorPage.tryAgainButtonLabel",
      defaultMessage: "Try again",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
      "data-test-subj": "infraLogViewErrorPageChangeConfigurationButton",
      iconType: "gear"
    }, settingsLinkProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceErrorPage.navigateToSettingsButtonLabel",
      defaultMessage: "Change configuration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 19
      }
    }))] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }));
};
exports.LogViewErrorPage = LogViewErrorPage;
const LogSourceErrorPage = exports.LogSourceErrorPage = LogViewErrorPage;
const LogSourceErrorMessage = ({
  error
}) => {
  if (error instanceof _common2.ResolveLogViewError) {
    var _error$cause$message, _error$cause;
    return /*#__PURE__*/_react.default.createElement(LogSourceErrorCallout, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logSourceErrorPage.resolveLogSourceConfigurationErrorTitle",
        defaultMessage: "Failed to resolve the log source configuration",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 7
      }
    }, error.cause instanceof _common.SavedObjectNotFound ?
    /*#__PURE__*/
    // the SavedObjectNotFound error message contains broken markup
    _react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceErrorPage.savedObjectNotFoundErrorMessage",
      defaultMessage: "Failed to locate that {savedObjectType}: {savedObjectId}",
      values: {
        savedObjectType: error.cause.savedObjectTypeDisplayName,
        savedObjectId: error.cause.savedObjectId
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }) : `${(_error$cause$message = (_error$cause = error.cause) === null || _error$cause === void 0 ? void 0 : _error$cause.message) !== null && _error$cause$message !== void 0 ? _error$cause$message : error.message}`);
  } else if (error instanceof _common2.FetchLogViewError) {
    var _error$cause$message2, _error$cause2;
    return /*#__PURE__*/_react.default.createElement(LogSourceErrorCallout, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logSourceErrorPage.fetchLogSourceConfigurationErrorTitle",
        defaultMessage: "Failed to load the log source configuration",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 7
      }
    }, `${(_error$cause$message2 = (_error$cause2 = error.cause) === null || _error$cause2 === void 0 ? void 0 : _error$cause2.message) !== null && _error$cause$message2 !== void 0 ? _error$cause$message2 : error.message}`);
  } else if (error instanceof _common2.FetchLogViewStatusError) {
    var _error$cause$message3, _error$cause3;
    return /*#__PURE__*/_react.default.createElement(LogSourceErrorCallout, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logSourceErrorPage.fetchLogSourceStatusErrorTitle",
        defaultMessage: "Failed to determine the status of the log source",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 7
      }
    }, `${(_error$cause$message3 = (_error$cause3 = error.cause) === null || _error$cause3 === void 0 ? void 0 : _error$cause3.message) !== null && _error$cause$message3 !== void 0 ? _error$cause$message3 : error.message}`);
  } else {
    return /*#__PURE__*/_react.default.createElement(LogSourceErrorCallout, {
      title: error.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 12
      }
    }, `${error.message}`);
  }
};
const LogSourceErrorCallout = ({
  title,
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  className: "eui-textLeft",
  color: "danger",
  iconType: "warning",
  title: title,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 151,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 152,
    columnNumber: 5
  }
}, children));