"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsDeprecationCallout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _routerUtils = require("@kbn/router-utils");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _react2 = require("@emotion/react");
var _common = require("@kbn/discover-plugin/common");
var _use_kibana = require("../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logs_deprecation_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const pageConfigurations = {
  stream: {
    dismissalStorageKey: 'log_stream_deprecation_callout_dismissed',
    message: _i18n.i18n.translate('xpack.infra.logsDeprecationCallout.stream.exploreWithDiscover', {
      defaultMessage: 'Logs Stream and Logs explorer are set to be deprecated. Switch to Discover and enable the new Observability solution for an improved logs experience.'
    })
  },
  settings: {
    dismissalStorageKey: 'log_settings_deprecation_callout_dismissed',
    message: _i18n.i18n.translate('xpack.infra.logsDeprecationCallout.settings.exploreWithDiscover', {
      defaultMessage: 'These settings only apply to the legacy Logs Stream app. Switch to Discover and enable the new Observability solution for an improved logs experience.'
    })
  }
};
const LogsDeprecationCallout = ({
  page
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      share,
      application: {
        capabilities: {
          discover_v2: discover,
          fleet
        }
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    dismissalStorageKey,
    message
  } = pageConfigurations[page];
  const [isDismissed, setDismissed] = (0, _useLocalStorage.default)(dismissalStorageKey, false);
  const discoverLocator = share.url.locators.get(_common.DISCOVER_APP_LOCATOR);
  if (isDismissed || !(discoverLocator && discover !== null && discover !== void 0 && discover.show && fleet !== null && fleet !== void 0 && fleet.read)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.infra.logsDeprecationCallout.euiCallOut.discoverANewLogLabel', {
      defaultMessage: "There's a new, better way to explore your logs!"
    }),
    color: "warning",
    iconType: "info",
    heading: "h2",
    onDismiss: () => setDismissed(true),
    css: (0, _react2.css)`
        margin-bottom: ${euiTheme.size.l};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, message), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    fill: true,
    "data-test-subj": "infraLogsDeprecationCalloutGoToDiscoverButton",
    color: "warning"
  }, getDiscoverLinkProps(discoverLocator), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), _i18n.i18n.translate('xpack.infra.logsDeprecationCallout.goToDiscoverButtonLabel', {
    defaultMessage: 'Go to Discover'
  })));
};
exports.LogsDeprecationCallout = LogsDeprecationCallout;
const getDiscoverLinkProps = locator => {
  return (0, _routerUtils.getRouterLinkProps)({
    href: locator.getRedirectUrl({}),
    onClick: () => locator.navigate({})
  });
};