"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserManagementLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_kibana = require("../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_setup/user_management_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UserManagementLink = props => {
  var _capabilities$managem, _capabilities$managem2, _capabilities$managem3;
  const {
    services: {
      application: {
        capabilities
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const canAccessUserManagement = (_capabilities$managem = capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$managem2 = capabilities.management) === null || _capabilities$managem2 === void 0 ? void 0 : (_capabilities$managem3 = _capabilities$managem2.security) === null || _capabilities$managem3 === void 0 ? void 0 : _capabilities$managem3.users) !== null && _capabilities$managem !== void 0 ? _capabilities$managem : false;
  const linkProps = (0, _public.useLinkProps)({
    app: 'management',
    pathname: '/security/users'
  });
  if (!canAccessUserManagement) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": "infraUserManagementLinkManageUsersButton",
    color: "primary",
    fill: true
  }, linkProps, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.analysis.userManagementButtonLabel",
    defaultMessage: "Manage users",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }));
};
exports.UserManagementLink = UserManagementLink;