"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _use_lens_attributes = require("../../hooks/use_lens_attributes");
var _lens_wrapper = require("./lens_wrapper");
var _chart_load_error = require("./chart_load_error");
var _constants = require("../../common/visualizations/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/lens/lens_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MIN_HEIGHT = 300;
const DEFAULT_DISABLED_ACTIONS = ['ACTION_CUSTOMIZE_PANEL', 'ACTION_EXPORT_CSV', 'embeddable_addToExistingCase', 'create-ml-ad-job-action'];
const LensChart = exports.LensChart = /*#__PURE__*/_react.default.memo(({
  id,
  borderRadius,
  dateRange,
  filters,
  hidePanelTitles,
  query,
  onBrushEnd,
  onFilter,
  overrides,
  toolTip,
  lastReloadRequestTime,
  disableTriggers = false,
  height = MIN_HEIGHT,
  loading = false,
  lensAttributes,
  withDefaultActions = true,
  disabledActions = DEFAULT_DISABLED_ACTIONS
}) => {
  const {
    formula,
    attributes,
    getExtraActions,
    error
  } = (0, _use_lens_attributes.useLensAttributes)(lensAttributes);
  const isLoading = loading || !attributes;
  const extraActions = getExtraActions({
    timeRange: dateRange,
    query,
    filters,
    lastReloadRequestTime
  });
  const handleBeforeBadgesRender = (0, _react.useCallback)(messages => {
    const missingFieldsMessage = messages.find(m => m.uniqueId === 'field_not_found' && m.severity === 'error');
    return missingFieldsMessage ? [{
      ...missingFieldsMessage,
      severity: 'warning',
      hidePopoverIcon: true,
      longMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.lens.customErrorHandler.title",
        defaultMessage: "No results found",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 23
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        "data-test-subj": "infraLensCustomErrorHanlderText",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.lens.customErrorHandler.description",
        defaultMessage: "To display this chart, please ensure you are collecting the following fields:",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 23
        }
      })), /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 21
        }
      }, missingFieldsMessage && missingFieldsMessage.longMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraLensCustomErrorHanlderLink",
        href: _constants.HOST_MISSING_FIELDS,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.customErrorHandler.learnMoreLink",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 21
        }
      })))
    }] : messages;
  }, []);
  const lens = /*#__PURE__*/_react.default.createElement(_lens_wrapper.LensWrapper, {
    id: id,
    attributes: attributes,
    dateRange: dateRange,
    disableTriggers: disableTriggers,
    extraActions: extraActions,
    withDefaultActions: withDefaultActions,
    disabledActions: disabledActions,
    filters: filters,
    hidePanelTitles: hidePanelTitles,
    loading: isLoading,
    style: {
      height
    },
    query: query,
    overrides: overrides,
    onBrushEnd: onBrushEnd,
    lastReloadRequestTime: lastReloadRequestTime,
    onFilter: onFilter,
    onBeforeBadgesRender: handleBeforeBadgesRender,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  });
  const content = !toolTip ? lens : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "regular",
    content: /*#__PURE__*/_react.default.cloneElement(toolTip, {
      formula
    }),
    anchorClassName: "eui-fullWidth",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }, lens));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: !!borderRadius,
    borderRadius: borderRadius,
    hasShadow: false,
    paddingSize: error ? 'm' : 'none',
    "data-test-subj": id,
    css: (0, _react2.css)`
          position: relative;
          min-height: ${height}px;
          .embPanel-isLoading {
            min-height: ${height}px;
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, error ? /*#__PURE__*/_react.default.createElement(_chart_load_error.ChartLoadError, {
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 18
    }
  }) : content);
});