"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _host_metrics = require("./host_metrics");
var _container_metrics = require("./container_metrics");
var _section = require("../../../components/section");
var _section_titles = require("../section_titles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/overview/metrics/metrics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetricsContent = ({
  entityType,
  ...props
}) => {
  const content = (0, _react.useMemo)(() => {
    switch (entityType) {
      case 'host':
        return /*#__PURE__*/_react.default.createElement(_host_metrics.HostMetrics, (0, _extends2.default)({}, props, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 27,
            columnNumber: 16
          }
        }));
      case 'container':
        return /*#__PURE__*/_react.default.createElement(_container_metrics.ContainerMetrics, (0, _extends2.default)({}, props, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 29,
            columnNumber: 16
          }
        }));
      default:
        return null;
    }
  }, [entityType, props]);
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_titles.MetricsSectionTitle, {
      entityType: entityType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 14
      }
    }),
    "data-test-subj": "infraAssetDetailsMetricsCollapsible",
    id: "metrics",
    collapsible: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, content);
};
exports.MetricsContent = MetricsContent;