"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddMetadataPinToRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/metadata/add_pin_to_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AddMetadataPinToRow = ({
  fieldName,
  pinnedItems,
  onPinned
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleAddPin = () => {
    onPinned([...pinnedItems, fieldName]);
  };
  const handleRemovePin = () => {
    if (pinnedItems && pinnedItems.includes(fieldName)) {
      onPinned((pinnedItems !== null && pinnedItems !== void 0 ? pinnedItems : []).filter(pinName => fieldName !== pinName));
    }
  };
  if (pinnedItems !== null && pinnedItems !== void 0 && pinnedItems.includes(fieldName)) {
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.infra.metadataEmbeddable.unpinField', {
        defaultMessage: 'Unpin field'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      color: "primary",
      iconType: "pinFilled",
      "data-test-subj": "infraAssetDetailsMetadataRemovePin",
      "aria-label": _i18n.i18n.translate('xpack.infra.metadata.pinnedAriaLabel', {
        defaultMessage: 'Pinned {fieldName}',
        values: {
          fieldName
        }
      }),
      onClick: handleRemovePin,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 11
      }
    })));
  }

  // Custom table show on hover CSS, since this button is not technically in an action column
  // Potential EUI TODO - multiple action columns and `align`ed actions are not currently supported
  const showOnRowHoverCss = (0, _css.css)`
    opacity: 0;
    ${_eui.euiCanAnimate} {
      transition: opacity ${euiTheme.animation.normal} ${euiTheme.animation.resistance};
    }

    .euiTableRow:hover &,
    &:focus-within {
      opacity: 1;
    }
  `;
  return /*#__PURE__*/_react.default.createElement("span", {
    className: showOnRowHoverCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.infra.metadataEmbeddable.pinField', {
      defaultMessage: 'Pin field'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "primary",
    size: "s",
    iconType: "pin",
    "data-test-subj": "infraAssetDetailsMetadataAddPin",
    "aria-label": _i18n.i18n.translate('xpack.infra.metadataEmbeddable.pinField.ariaLabel', {
      defaultMessage: 'Pin {fieldName}',
      values: {
        fieldName
      }
    }),
    onClick: handleAddPin,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  })));
};
exports.AddMetadataPinToRow = AddMetadataPinToRow;