"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddMetadataFilterButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_kibana = require("../../../../hooks/use_kibana");
var _build_metadata_filter = require("./build_metadata_filter");
var _use_unified_search = require("../../../../pages/metrics/hosts/hooks/use_unified_search");
var _use_data_views = require("../../hooks/use_data_views");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/metadata/add_metadata_filter_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const filterAddedToastTitle = _i18n.i18n.translate('xpack.infra.metadataEmbeddable.filterAdded', {
  defaultMessage: 'Filter was added'
});
const AddMetadataFilterButton = ({
  item
}) => {
  const {
    metrics
  } = (0, _use_data_views.useDataViewsContext)();
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    services: {
      data: {
        query: {
          filterManager: filterManagerService
        }
      },
      notifications: {
        toasts: toastsService
      },
      telemetry
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const existingFilter = (0, _react.useMemo)(() => searchCriteria === null || searchCriteria === void 0 ? void 0 : searchCriteria.filters.find(filter => filter.meta.key === item.name), [item.name, searchCriteria === null || searchCriteria === void 0 ? void 0 : searchCriteria.filters]);
  const handleAddFilter = () => {
    var _item$value;
    const newFilter = (0, _build_metadata_filter.buildMetadataFilter)({
      field: item.name,
      value: (_item$value = item.value) !== null && _item$value !== void 0 ? _item$value : '',
      dataView: metrics.dataView,
      negate: false
    });
    if (newFilter) {
      telemetry.reportHostFlyoutFilterAdded({
        field_name: item.name
      });
      filterManagerService.addFilters(newFilter);
      toastsService.addSuccess({
        title: filterAddedToastTitle,
        toastLifeTimeMs: 10000
      });
    }
  };
  if (existingFilter) {
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.infra.metadataEmbeddable.setRemoveFilterTooltip', {
        defaultMessage: 'Remove filter'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      color: "text",
      iconType: "filter",
      display: "base",
      "data-test-subj": "infraAssetDetailsMetadataRemoveFilterButton",
      "aria-label": _i18n.i18n.translate('xpack.infra.metadataEmbeddable.filterAriaLabel', {
        defaultMessage: 'Filter'
      }),
      onClick: () => {
        telemetry.reportHostFlyoutFilterRemoved({
          field_name: existingFilter.meta.key
        });
        filterManagerService.removeFilter(existingFilter);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `infraAssetDetailsMetadataField.${item.name}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.infra.metadataEmbeddable.setFilterByValueTooltip', {
      defaultMessage: 'Filter by value'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "primary",
    size: "s",
    iconType: "filter",
    "data-test-subj": "infraAssetDetailsMetadataAddFilterButton",
    "aria-label": _i18n.i18n.translate('xpack.infra.metadataEmbeddable.AddFilterAriaLabel', {
      defaultMessage: 'Add filter and reload page'
    }),
    onClick: handleAddFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  })));
};
exports.AddMetadataFilterButton = AddMetadataFilterButton;